/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPrefixFilter {
    Filter mainFilter;
    static final char FIRST_CHAR = 'a';
    static final char LAST_CHAR = 'e';
    static final String HOST_PREFIX = "org.apache.site-";
    static final byte[] GOOD_BYTES = Bytes.toBytes("abc");

    @Before
    public void setUp() throws Exception {
        this.mainFilter = new PrefixFilter(Bytes.toBytes(HOST_PREFIX));
    }

    @Test
    public void testPrefixOnRow() throws Exception {
        this.prefixRowTests(this.mainFilter);
    }

    @Test
    public void testPrefixOnRowInsideWhileMatchRow() throws Exception {
        this.prefixRowTests(new WhileMatchFilter(this.mainFilter), true);
    }

    @Test
    public void testSerialization() throws Exception {
        byte[] buffer = this.mainFilter.toByteArray();
        PrefixFilter newFilter = PrefixFilter.parseFrom(buffer);
        this.prefixRowTests(newFilter);
    }

    private void prefixRowTests(Filter filter) throws Exception {
        this.prefixRowTests(filter, false);
    }

    private void prefixRowTests(Filter filter, boolean lastFilterAllRemaining) throws Exception {
        for (char c = 'a'; c <= 'e'; c = (char)(c + '\u0001')) {
            byte[] t = this.createRow(c);
            Assert.assertFalse((String)("Failed with character " + c), (boolean)filter.filterRowKey(t, 0, t.length));
            Assert.assertFalse((boolean)filter.filterAllRemaining());
        }
        String yahooSite = "com.yahoo.www";
        byte[] yahooSiteBytes = Bytes.toBytes(yahooSite);
        Assert.assertTrue((String)("Failed with character " + yahooSite), (boolean)filter.filterRowKey(yahooSiteBytes, 0, yahooSiteBytes.length));
        Assert.assertEquals((Object)filter.filterAllRemaining(), (Object)lastFilterAllRemaining);
    }

    private byte[] createRow(char c) {
        return Bytes.toBytes(HOST_PREFIX + Character.toString(c));
    }
}

