/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class HalfStoreFileReader
extends StoreFile.Reader {
    final Log LOG = LogFactory.getLog(HalfStoreFileReader.class);
    final boolean top;
    protected final byte[] splitkey;
    private byte[] firstKey = null;
    private boolean firstKeySeeked = false;

    public HalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, Reference r, Configuration conf) throws IOException {
        super(fs, p, cacheConf, conf);
        this.splitkey = r.getSplitKey();
        this.top = Reference.isTopFileRegion(r.getFileRegion());
    }

    public HalfStoreFileReader(FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, Configuration conf) throws IOException {
        super(fs, p, in, size, cacheConf, conf);
        this.splitkey = r.getSplitKey();
        this.top = Reference.isTopFileRegion(r.getFileRegion());
    }

    protected boolean isTop() {
        return this.top;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        final HFileScanner s = super.getScanner(cacheBlocks, pread, isCompaction);
        return new HFileScanner(){
            final HFileScanner delegate;
            public boolean atEnd;
            {
                this.delegate = s;
                this.atEnd = false;
            }

            @Override
            public ByteBuffer getKey() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKey();
            }

            @Override
            public String getKeyString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKeyString();
            }

            @Override
            public ByteBuffer getValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValue();
            }

            @Override
            public String getValueString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValueString();
            }

            @Override
            public KeyValue getKeyValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKeyValue();
            }

            @Override
            public boolean next() throws IOException {
                if (this.atEnd) {
                    return false;
                }
                boolean b = this.delegate.next();
                if (!b) {
                    return b;
                }
                if (!HalfStoreFileReader.this.top) {
                    ByteBuffer bb = this.getKey();
                    if (HalfStoreFileReader.this.getComparator().compareFlatKey(bb.array(), bb.arrayOffset(), bb.limit(), HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) >= 0) {
                        this.atEnd = true;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean seekBefore(byte[] key) throws IOException {
                return this.seekBefore(key, 0, key.length);
            }

            @Override
            public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
                if (HalfStoreFileReader.this.top) {
                    byte[] fk = HalfStoreFileReader.this.getFirstKey();
                    if (fk == null) {
                        return false;
                    }
                    if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, fk, 0, fk.length) <= 0) {
                        return false;
                    }
                } else if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) >= 0) {
                    return this.delegate.seekBefore(HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length);
                }
                return this.delegate.seekBefore(key, offset, length);
            }

            @Override
            public boolean seekTo() throws IOException {
                if (HalfStoreFileReader.this.top) {
                    int r = this.delegate.seekTo(HalfStoreFileReader.this.splitkey);
                    if (r == -2) {
                        return true;
                    }
                    if (r < 0) {
                        return this.delegate.seekTo();
                    }
                    if (r > 0) {
                        return this.delegate.next();
                    }
                    return true;
                }
                boolean b = this.delegate.seekTo();
                if (!b) {
                    return b;
                }
                ByteBuffer k = this.delegate.getKey();
                return this.delegate.getReader().getComparator().compareFlatKey(k.array(), k.arrayOffset(), k.limit(), HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) < 0;
            }

            @Override
            public int seekTo(byte[] key) throws IOException {
                return this.seekTo(key, 0, key.length);
            }

            @Override
            public int seekTo(byte[] key, int offset, int length) throws IOException {
                if (HalfStoreFileReader.this.top) {
                    if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) < 0) {
                        return -1;
                    }
                } else if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) >= 0) {
                    boolean res = this.delegate.seekBefore(HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                return this.delegate.seekTo(key, offset, length);
            }

            @Override
            public int reseekTo(byte[] key) throws IOException {
                return this.reseekTo(key, 0, key.length);
            }

            @Override
            public int reseekTo(byte[] key, int offset, int length) throws IOException {
                if (HalfStoreFileReader.this.top) {
                    if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) < 0) {
                        return -1;
                    }
                } else if (HalfStoreFileReader.this.getComparator().compareFlatKey(key, offset, length, HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length) >= 0) {
                    boolean res = this.delegate.seekBefore(HalfStoreFileReader.this.splitkey, 0, HalfStoreFileReader.this.splitkey.length);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                if (this.atEnd) {
                    return 1;
                }
                return this.delegate.reseekTo(key, offset, length);
            }

            @Override
            public HFile.Reader getReader() {
                return this.delegate.getReader();
            }

            @Override
            public boolean isSeeked() {
                return this.delegate.isSeeked();
            }
        };
    }

    @Override
    public boolean passesKeyRangeFilter(Scan scan) {
        return true;
    }

    @Override
    public byte[] getLastKey() {
        if (this.top) {
            return super.getLastKey();
        }
        HFileScanner scanner = this.getScanner(true, true);
        try {
            if (scanner.seekBefore(this.splitkey)) {
                return Bytes.toBytes(scanner.getKey());
            }
        }
        catch (IOException e) {
            this.LOG.warn("Failed seekBefore " + Bytes.toStringBinary(this.splitkey), e);
        }
        return null;
    }

    @Override
    public byte[] midkey() throws IOException {
        return null;
    }

    @Override
    public byte[] getFirstKey() {
        if (!this.firstKeySeeked) {
            HFileScanner scanner = this.getScanner(true, true, false);
            try {
                if (scanner.seekTo()) {
                    this.firstKey = Bytes.toBytes(scanner.getKey());
                }
                this.firstKeySeeked = true;
            }
            catch (IOException e) {
                this.LOG.warn("Failed seekTo first KV in the file", e);
            }
        }
        return this.firstKey;
    }

    @Override
    public long getEntries() {
        return super.getEntries() / 2L;
    }

    @Override
    public long getFilterEntries() {
        return super.getFilterEntries() / 2L;
    }
}

