/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class TagCompressionContext {
    private final Dictionary tagDict;

    public TagCompressionContext(Class<? extends Dictionary> dictType, int dictCapacity) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Dictionary> dictConstructor = dictType.getConstructor(new Class[0]);
        this.tagDict = dictConstructor.newInstance(new Object[0]);
        this.tagDict.init(dictCapacity);
    }

    public void clear() {
        this.tagDict.clear();
    }

    public void compressTags(OutputStream out, byte[] in, int offset, short length) throws IOException {
        short tagLen;
        int pos;
        int endOffset = pos + length;
        assert (pos < endOffset);
        for (pos = offset; pos < endOffset; pos += tagLen) {
            tagLen = Bytes.toShort(in, pos);
            this.write(in, pos += 2, tagLen, out);
        }
    }

    public void compressTags(OutputStream out, ByteBuffer in, short length) throws IOException {
        if (in.hasArray()) {
            this.compressTags(out, in.array(), in.arrayOffset() + in.position(), length);
            ByteBufferUtils.skip(in, length);
        } else {
            byte[] tagBuf = new byte[length];
            in.get(tagBuf);
            this.compressTags(out, tagBuf, 0, length);
        }
    }

    public void uncompressTags(InputStream src, byte[] dest, int offset, short length) throws IOException {
        int endOffset = offset + length;
        while (offset < endOffset) {
            byte status = (byte)src.read();
            if (status == -1) {
                short tagLen = (short)StreamUtils.readRawVarint32(src);
                offset = Bytes.putShort(dest, offset, tagLen);
                IOUtils.readFully(src, dest, offset, tagLen);
                this.tagDict.addEntry(dest, offset, tagLen);
                offset += tagLen;
                continue;
            }
            short dictIdx = StreamUtils.toShort(status, (byte)src.read());
            byte[] entry = this.tagDict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            offset = Bytes.putShort(dest, offset, (short)entry.length);
            System.arraycopy(entry, 0, dest, offset, entry.length);
            offset += entry.length;
        }
    }

    public int uncompressTags(ByteBuffer src, byte[] dest, int offset, int length) throws IOException {
        int srcBeginPos = src.position();
        int endOffset = offset + length;
        while (offset < endOffset) {
            short tagLen;
            byte status = src.get();
            if (status == -1) {
                tagLen = (short)StreamUtils.readRawVarint32(src);
                offset = Bytes.putShort(dest, offset, tagLen);
                src.get(dest, offset, tagLen);
                this.tagDict.addEntry(dest, offset, tagLen);
                offset += tagLen;
                continue;
            }
            short dictIdx = StreamUtils.toShort(status, src.get());
            byte[] entry = this.tagDict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            tagLen = (short)entry.length;
            offset = Bytes.putShort(dest, offset, tagLen);
            System.arraycopy(entry, 0, dest, offset, tagLen);
            offset += tagLen;
        }
        return src.position() - srcBeginPos;
    }

    public void uncompressTags(InputStream src, ByteBuffer dest, short length) throws IOException {
        if (dest.hasArray()) {
            this.uncompressTags(src, dest.array(), dest.arrayOffset() + dest.position(), length);
        } else {
            byte[] tagBuf = new byte[length];
            this.uncompressTags(src, tagBuf, 0, length);
            dest.put(tagBuf);
        }
    }

    private void write(byte[] data, int offset, short length, OutputStream out) throws IOException {
        short dictIdx = -1;
        if (this.tagDict != null) {
            dictIdx = this.tagDict.findEntry(data, offset, length);
        }
        if (dictIdx == -1) {
            out.write(-1);
            StreamUtils.writeRawVInt32(out, length);
            out.write(data, offset, length);
        } else {
            StreamUtils.writeShort(out, dictIdx);
        }
    }
}

