/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.hadoop.hbase.io.crypto.KeyStoreKeyProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Encryption {
    private static final Log LOG = LogFactory.getLog(Encryption.class);
    static final Map<Pair<String, String>, KeyProvider> keyProviderCache = new ConcurrentHashMap<Pair<String, String>, KeyProvider>();

    public static Context newContext() {
        return new Context();
    }

    public static Context newContext(Configuration conf) {
        return new Context(conf);
    }

    private Encryption() {
    }

    public static Cipher getCipher(Configuration conf, String name) {
        return Encryption.getCipherProvider(conf).getCipher(name);
    }

    public static String[] getSupportedCiphers() {
        return Encryption.getSupportedCiphers(HBaseConfiguration.create());
    }

    public static String[] getSupportedCiphers(Configuration conf) {
        return Encryption.getCipherProvider(conf).getSupportedCiphers();
    }

    public static byte[] hash128(String ... args) {
        byte[] result = new byte[16];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (String arg : args) {
                md.update(Bytes.toBytes(arg));
            }
            md.digest(result, 0, result.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash128(byte[] ... args) {
        byte[] result = new byte[16];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (byte[] arg : args) {
                md.update(arg);
            }
            md.digest(result, 0, result.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash256(String ... args) {
        byte[] result = new byte[32];
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (String arg : args) {
                md.update(Bytes.toBytes(arg));
            }
            md.digest(result, 0, result.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash256(byte[] ... args) {
        byte[] result = new byte[32];
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (byte[] arg : args) {
                md.update(arg);
            }
            md.digest(result, 0, result.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(OutputStream out, byte[] src, int offset, int length, Encryptor e) throws IOException {
        OutputStream cout = e.createEncryptionStream(out);
        try {
            cout.write(src, offset, length);
        }
        finally {
            cout.close();
        }
    }

    public static void encrypt(OutputStream out, byte[] src, int offset, int length, Context context, byte[] iv) throws IOException {
        Encryptor e = context.getCipher().getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        e.reset();
        Encryption.encrypt(out, src, offset, length, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(OutputStream out, InputStream in, Encryptor e) throws IOException {
        OutputStream cout = e.createEncryptionStream(out);
        try {
            IOUtils.copy(in, cout);
        }
        finally {
            cout.close();
        }
    }

    public static void encrypt(OutputStream out, InputStream in, Context context, byte[] iv) throws IOException {
        Encryptor e = context.getCipher().getEncryptor();
        e.setKey(context.getKey());
        e.setIv(iv);
        e.reset();
        Encryption.encrypt(out, in, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(byte[] dest, int destOffset, InputStream in, int destSize, Decryptor d) throws IOException {
        InputStream cin = d.createDecryptionStream(in);
        try {
            IOUtils.readFully(cin, dest, destOffset, destSize);
        }
        finally {
            cin.close();
        }
    }

    public static void decrypt(byte[] dest, int destOffset, InputStream in, int destSize, Context context, byte[] iv) throws IOException {
        Decryptor d = context.getCipher().getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        Encryption.decrypt(dest, destOffset, in, destSize, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(OutputStream out, InputStream in, int outLen, Decryptor d) throws IOException {
        InputStream cin = d.createDecryptionStream(in);
        byte[] buf = new byte[8192];
        try {
            int read;
            for (long remaining = (long)outLen; remaining > 0L; remaining -= (long)read) {
                int toRead = (int)(remaining < (long)buf.length ? remaining : (long)buf.length);
                read = cin.read(buf, 0, toRead);
                if (read < 0) {
                    break;
                }
                out.write(buf, 0, read);
            }
        }
        finally {
            cin.close();
        }
    }

    public static void decrypt(OutputStream out, InputStream in, int outLen, Context context, byte[] iv) throws IOException {
        Decryptor d = context.getCipher().getDecryptor();
        d.setKey(context.getKey());
        d.setIv(iv);
        Encryption.decrypt(out, in, outLen, d);
    }

    public static Key getSecretKeyForSubject(String subject, Configuration conf) throws IOException {
        KeyProvider provider = Encryption.getKeyProvider(conf);
        if (provider != null) {
            try {
                Key[] keys = provider.getKeys(new String[]{subject});
                if (keys != null && keys.length > 0) {
                    return keys[0];
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        throw new IOException("No key found for subject '" + subject + "'");
    }

    public static void encryptWithSubjectKey(OutputStream out, InputStream in, String subject, Configuration conf, Cipher cipher, byte[] iv) throws IOException {
        Key key = Encryption.getSecretKeyForSubject(subject, conf);
        if (key == null) {
            throw new IOException("No key found for subject '" + subject + "'");
        }
        Encryptor e = cipher.getEncryptor();
        e.setKey(key);
        e.setIv(iv);
        Encryption.encrypt(out, in, e);
    }

    public static void decryptWithSubjectKey(OutputStream out, InputStream in, int outLen, String subject, Configuration conf, Cipher cipher, byte[] iv) throws IOException {
        Key key = Encryption.getSecretKeyForSubject(subject, conf);
        if (key == null) {
            throw new IOException("No key found for subject '" + subject + "'");
        }
        Decryptor d = cipher.getDecryptor();
        d.setKey(key);
        d.setIv(iv);
        Encryption.decrypt(out, in, outLen, d);
    }

    private static ClassLoader getClassLoaderForClass(Class<?> c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = c.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new RuntimeException("A ClassLoader to load the Cipher could not be determined");
        }
        return cl;
    }

    public static CipherProvider getCipherProvider(Configuration conf) {
        String providerClassName = conf.get("hbase.crypto.cipherprovider", DefaultCipherProvider.class.getName());
        try {
            CipherProvider provider = (CipherProvider)ReflectionUtils.newInstance(Encryption.getClassLoaderForClass(CipherProvider.class).loadClass(providerClassName), conf);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyProvider getKeyProvider(Configuration conf) {
        String providerClassName = conf.get("hbase.crypto.keyprovider", KeyStoreKeyProvider.class.getName());
        String providerParameters = conf.get("hbase.crypto.keyprovider.parameters", "");
        try {
            Pair<String, String> providerCacheKey = new Pair<String, String>(providerClassName, providerParameters);
            KeyProvider provider = keyProviderCache.get(providerCacheKey);
            if (provider != null) {
                return provider;
            }
            provider = (KeyProvider)ReflectionUtils.newInstance(Encryption.getClassLoaderForClass(KeyProvider.class).loadClass(providerClassName), conf);
            provider.init(providerParameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Installed " + providerClassName + " into key provider cache");
            }
            keyProviderCache.put(providerCacheKey, provider);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void incrementIv(byte[] iv) {
        int length = iv.length;
        boolean carry = true;
        for (int i = 0; i < length && carry; ++i) {
            iv[i] = (byte)(iv[i] + 1 & 0xFF);
            carry = 0 == iv[i];
        }
    }

    public static class Context
    extends org.apache.hadoop.hbase.io.crypto.Context {
        public static final Context NONE = new Context();

        private Context() {
        }

        private Context(Configuration conf) {
            super(conf);
        }

        @Override
        public Context setCipher(Cipher cipher) {
            super.setCipher(cipher);
            return this;
        }

        @Override
        public Context setKey(Key key) {
            super.setKey(key);
            return this;
        }

        public Context setKey(byte[] key) {
            super.setKey(new SecretKeySpec(key, this.getCipher().getName()));
            return this;
        }
    }
}

