/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;

@InterfaceAudience.Private
public class HFileBlockDefaultDecodingContext
implements HFileBlockDecodingContext {
    private final HFileContext fileContext;
    private TagCompressionContext tagCompressionContext;

    public HFileBlockDefaultDecodingContext(HFileContext fileContext) {
        this.fileContext = fileContext;
    }

    @Override
    public void prepareDecoding(int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, ByteBuffer blockBufferWithoutHeader, byte[] onDiskBlock, int offset) throws IOException {
        Compression.Algorithm compression;
        InputStream in = new DataInputStream(new ByteArrayInputStream(onDiskBlock, offset, onDiskSizeWithoutHeader));
        Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
        if (cryptoContext != Encryption.Context.NONE) {
            Cipher cipher = cryptoContext.getCipher();
            Decryptor decryptor = cipher.getDecryptor();
            decryptor.setKey(cryptoContext.getKey());
            int ivLength = ((InputStream)in).read();
            if (ivLength > 0) {
                byte[] iv = new byte[ivLength];
                IOUtils.readFully(in, iv);
                decryptor.setIv(iv);
                decryptor.reset();
                in = decryptor.createDecryptionStream(in);
            }
            onDiskSizeWithoutHeader -= 1 + ivLength;
        }
        if ((compression = this.fileContext.getCompression()) != Compression.Algorithm.NONE) {
            Compression.decompress(blockBufferWithoutHeader.array(), blockBufferWithoutHeader.arrayOffset(), in, onDiskSizeWithoutHeader, uncompressedSizeWithoutHeader, compression);
        } else {
            IOUtils.readFully(in, blockBufferWithoutHeader.array(), blockBufferWithoutHeader.arrayOffset(), onDiskSizeWithoutHeader);
        }
    }

    @Override
    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    public TagCompressionContext getTagCompressionContext() {
        return this.tagCompressionContext;
    }

    public void setTagCompressionContext(TagCompressionContext tagCompressionContext) {
        this.tagCompressionContext = tagCompressionContext;
    }
}

