/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;

@InterfaceAudience.Private
public class HFileBlockDefaultEncodingContext
implements HFileBlockEncodingContext {
    private byte[] onDiskBytesWithHeader;
    private byte[] uncompressedBytesWithHeader;
    private BlockType blockType;
    private final DataBlockEncoding encodingAlgo;
    private ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
    private DataOutputStream dataOut = new DataOutputStream(this.encodedStream);
    private byte[] dummyHeader;
    private Compressor compressor;
    private CompressionOutputStream compressionStream;
    private ByteArrayOutputStream compressedByteStream;
    private HFileContext fileContext;
    private TagCompressionContext tagCompressionContext;
    private ByteArrayOutputStream cryptoByteStream;
    private byte[] iv;

    public HFileBlockDefaultEncodingContext(DataBlockEncoding encoding, byte[] headerBytes, HFileContext fileContext) {
        Encryption.Context cryptoContext;
        Compression.Algorithm compressionAlgorithm;
        this.encodingAlgo = encoding;
        this.fileContext = fileContext;
        Compression.Algorithm algorithm = compressionAlgorithm = fileContext.getCompression() == null ? Compression.Algorithm.NONE : fileContext.getCompression();
        if (compressionAlgorithm != Compression.Algorithm.NONE) {
            this.compressor = compressionAlgorithm.getCompressor();
            this.compressedByteStream = new ByteArrayOutputStream();
            try {
                this.compressionStream = compressionAlgorithm.createPlainCompressionStream(this.compressedByteStream, this.compressor);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create compression stream for algorithm " + (Object)((Object)compressionAlgorithm), e);
            }
        }
        if ((cryptoContext = fileContext.getEncryptionContext()) != Encryption.Context.NONE) {
            this.cryptoByteStream = new ByteArrayOutputStream();
            this.iv = new byte[cryptoContext.getCipher().getIvLength()];
            new SecureRandom().nextBytes(this.iv);
        }
        this.dummyHeader = Preconditions.checkNotNull(headerBytes, "Please pass HConstants.HFILEBLOCK_DUMMY_HEADER instead of null for param headerBytes");
    }

    @Override
    public void setDummyHeader(byte[] headerBytes) {
        this.dummyHeader = headerBytes;
    }

    public void prepareEncoding() throws IOException {
        this.encodedStream.reset();
        this.dataOut.write(this.dummyHeader);
        if (this.encodingAlgo != null && this.encodingAlgo != DataBlockEncoding.NONE) {
            this.encodingAlgo.writeIdInBytes(this.dataOut);
        }
    }

    @Override
    public void postEncoding(BlockType blockType) throws IOException {
        this.dataOut.flush();
        this.compressAfterEncodingWithBlockType(this.encodedStream.toByteArray(), blockType);
        this.blockType = blockType;
    }

    public void compressAfterEncodingWithBlockType(byte[] uncompressedBytesWithHeader, BlockType blockType) throws IOException {
        this.compressAfterEncoding(uncompressedBytesWithHeader, blockType, this.dummyHeader);
    }

    protected void compressAfterEncoding(byte[] uncompressedBytesWithHeader, BlockType blockType, byte[] headerBytes) throws IOException {
        this.uncompressedBytesWithHeader = uncompressedBytesWithHeader;
        Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
        if (cryptoContext != Encryption.Context.NONE) {
            ByteArrayInputStream in;
            int plaintextLength;
            this.cryptoByteStream.reset();
            this.cryptoByteStream.write(headerBytes);
            if (this.fileContext.getCompression() != Compression.Algorithm.NONE) {
                this.compressedByteStream.reset();
                this.compressionStream.resetState();
                this.compressionStream.write(uncompressedBytesWithHeader, headerBytes.length, uncompressedBytesWithHeader.length - headerBytes.length);
                this.compressionStream.flush();
                this.compressionStream.finish();
                byte[] plaintext = this.compressedByteStream.toByteArray();
                plaintextLength = plaintext.length;
                in = new ByteArrayInputStream(plaintext);
            } else {
                plaintextLength = uncompressedBytesWithHeader.length - headerBytes.length;
                in = new ByteArrayInputStream(uncompressedBytesWithHeader, headerBytes.length, plaintextLength);
            }
            if (plaintextLength > 0) {
                Cipher cipher = cryptoContext.getCipher();
                Encryptor encryptor = cipher.getEncryptor();
                encryptor.setKey(cryptoContext.getKey());
                int ivLength = this.iv.length;
                Preconditions.checkState(ivLength <= 127, "IV length out of range");
                this.cryptoByteStream.write(ivLength);
                if (ivLength > 0) {
                    Encryption.incrementIv(this.iv);
                    encryptor.setIv(this.iv);
                    this.cryptoByteStream.write(this.iv);
                }
                Encryption.encrypt(this.cryptoByteStream, in, encryptor);
                this.onDiskBytesWithHeader = this.cryptoByteStream.toByteArray();
            } else {
                this.cryptoByteStream.write(0);
                this.onDiskBytesWithHeader = this.cryptoByteStream.toByteArray();
            }
        } else if (this.fileContext.getCompression() != Compression.Algorithm.NONE) {
            this.compressedByteStream.reset();
            this.compressedByteStream.write(headerBytes);
            this.compressionStream.resetState();
            this.compressionStream.write(uncompressedBytesWithHeader, headerBytes.length, uncompressedBytesWithHeader.length - headerBytes.length);
            this.compressionStream.flush();
            this.compressionStream.finish();
            this.onDiskBytesWithHeader = this.compressedByteStream.toByteArray();
        } else {
            this.onDiskBytesWithHeader = uncompressedBytesWithHeader;
        }
        this.blockType = blockType;
    }

    @Override
    public byte[] getOnDiskBytesWithHeader() {
        return this.onDiskBytesWithHeader;
    }

    @Override
    public byte[] getUncompressedBytesWithHeader() {
        return this.uncompressedBytesWithHeader;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public void close() {
        if (this.compressor != null) {
            this.fileContext.getCompression().returnCompressor(this.compressor);
            this.compressor = null;
        }
    }

    @Override
    public DataOutputStream getOutputStreamForEncoder() {
        return this.dataOut;
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.encodingAlgo;
    }

    @Override
    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    public TagCompressionContext getTagCompressionContext() {
        return this.tagCompressionContext;
    }

    public void setTagCompressionContext(TagCompressionContext tagCompressionContext) {
        this.tagCompressionContext = tagCompressionContext;
    }
}

