/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestChangingEncoding {
    private static final Log LOG = LogFactory.getLog(TestChangingEncoding.class);
    static final String CF = "EncodingTestCF";
    static final byte[] CF_BYTES = Bytes.toBytes("EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 100;
    private static final int NUM_COLS_PER_ROW = 20;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final int TIMEOUT_MS = 600000;
    private HBaseAdmin admin;
    private HColumnDescriptor hcd;
    private String tableName;
    private static final List<DataBlockEncoding> ENCODINGS_TO_ITERATE = TestChangingEncoding.createEncodingsToIterate();
    private int numBatchesWritten;

    private static final List<DataBlockEncoding> createEncodingsToIterate() {
        ArrayList<DataBlockEncoding> encodings = new ArrayList<DataBlockEncoding>(Arrays.asList(DataBlockEncoding.values()));
        encodings.add(DataBlockEncoding.NONE);
        return Collections.unmodifiableList(encodings);
    }

    private void prepareTest(String testId) throws IOException {
        this.tableName = "test_table_" + testId;
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(this.tableName));
        this.hcd = new HColumnDescriptor(CF);
        htd.addFamily(this.hcd);
        this.admin.createTable(htd);
        this.numBatchesWritten = 0;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = new HBaseAdmin(conf);
    }

    @After
    public void tearDown() throws IOException {
        this.admin.close();
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes("batch" + batchId + "_row" + i);
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes("col" + j);
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes("value_for_" + Bytes.toString(TestChangingEncoding.getRowKey(batchId, i)) + "_col" + j);
    }

    static void writeTestDataBatch(Configuration conf, String tableName, int batchId) throws Exception {
        LOG.debug("Writing test data batch " + batchId);
        HTable table = new HTable(conf, tableName);
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(TestChangingEncoding.getRowKey(batchId, i));
            for (int j = 0; j < 20; ++j) {
                put.add(CF_BYTES, TestChangingEncoding.getQualifier(j), TestChangingEncoding.getValue(batchId, i, j));
            }
            put.setDurability(Durability.SKIP_WAL);
            table.put(put);
        }
        table.close();
    }

    static void verifyTestDataBatch(Configuration conf, String tableName, int batchId) throws Exception {
        LOG.debug("Verifying test data batch " + batchId);
        HTable table = new HTable(conf, tableName);
        for (int i = 0; i < 100; ++i) {
            Get get = new Get(TestChangingEncoding.getRowKey(batchId, i));
            Result result = table.get(get);
            for (int j = 0; j < 20; ++j) {
                Cell kv = result.getColumnLatestCell(CF_BYTES, TestChangingEncoding.getQualifier(j));
                Assert.assertTrue((boolean)CellUtil.matchingValue(kv, TestChangingEncoding.getValue(batchId, i, j)));
            }
        }
        table.close();
    }

    private void writeSomeNewData() throws Exception {
        TestChangingEncoding.writeTestDataBatch(conf, this.tableName, this.numBatchesWritten);
        ++this.numBatchesWritten;
    }

    private void verifyAllData() throws Exception {
        for (int i = 0; i < this.numBatchesWritten; ++i) {
            TestChangingEncoding.verifyTestDataBatch(conf, this.tableName, i);
        }
    }

    private void setEncodingConf(DataBlockEncoding encoding, boolean onlineChange) throws Exception {
        LOG.debug("Setting CF encoding to " + (Object)((Object)encoding) + " (ordinal=" + encoding.ordinal() + "), onlineChange=" + onlineChange);
        this.hcd.setDataBlockEncoding(encoding);
        if (!onlineChange) {
            this.admin.disableTable(this.tableName);
        }
        this.admin.modifyColumn(this.tableName, this.hcd);
        if (!onlineChange) {
            this.admin.enableTable(this.tableName);
        }
        ZKAssign.blockUntilNoRIT(TEST_UTIL.getZooKeeperWatcher());
    }

    @Test(timeout=600000L)
    public void testChangingEncoding() throws Exception {
        this.prepareTest("ChangingEncoding");
        for (boolean onlineChange : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, onlineChange);
                this.writeSomeNewData();
                this.verifyAllData();
            }
        }
    }

    @Test(timeout=600000L)
    public void testChangingEncodingWithCompaction() throws Exception {
        this.prepareTest("ChangingEncodingWithCompaction");
        for (boolean onlineChange : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, onlineChange);
                this.writeSomeNewData();
                this.verifyAllData();
                this.compactAndWait();
                this.verifyAllData();
            }
        }
    }

    private void compactAndWait() throws IOException, InterruptedException {
        boolean cont;
        LOG.debug("Compacting table " + this.tableName);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        this.admin.majorCompact(this.tableName);
        long maxWaitime = System.currentTimeMillis() + 500L;
        do {
            cont = rs.compactSplitThread.getCompactionQueueSize() == 0;
            Threads.sleep(1L);
        } while (cont && System.currentTimeMillis() < maxWaitime);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep(1L);
        }
        LOG.debug("Compaction queue size reached 0, continuing");
    }

    @Test
    public void testCrazyRandomChanges() throws Exception {
        this.prepareTest("RandomChanges");
        Random rand = new Random(2934298742974297L);
        for (int i = 0; i < 20; ++i) {
            int encodingOrdinal = rand.nextInt(DataBlockEncoding.values().length);
            DataBlockEncoding encoding = DataBlockEncoding.values()[encodingOrdinal];
            this.setEncodingConf(encoding, rand.nextBoolean());
            this.writeSomeNewData();
            this.verifyAllData();
        }
    }
}

