/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.TestMiniClusterLoadSequential;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
public class TestLoadAndSwitchEncodeOnDisk
extends TestMiniClusterLoadSequential {
    private static final boolean USE_MULTI_PUT = true;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{new Object[0]});
    }

    public TestLoadAndSwitchEncodeOnDisk() {
        super(true, DataBlockEncoding.PREFIX);
        this.conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
    }

    @Override
    protected int numKeys() {
        return 3000;
    }

    @Override
    @Test(timeout=180000L)
    public void loadTest() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        this.compression = Compression.Algorithm.GZ;
        super.loadTest();
        HColumnDescriptor hcd = this.getColumnDesc(admin);
        System.err.println("\nDisabling encode-on-disk. Old column descriptor: " + hcd + "\n");
        HTable t = new HTable(this.conf, TABLE);
        this.assertAllOnLine(t);
        admin.disableTable(TABLE);
        admin.modifyColumn(TABLE, hcd);
        System.err.println("\nRe-enabling table\n");
        admin.enableTable(TABLE);
        System.err.println("\nNew column descriptor: " + this.getColumnDesc(admin) + "\n");
        this.assertAllOnLine(t);
        System.err.println("\nCompacting the table\n");
        admin.majorCompact(TABLE.getName());
        Threads.sleepWithoutInterrupt(5000L);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep(50L);
        }
        System.err.println("\nDone with the test, shutting down the cluster\n");
    }

    private void assertAllOnLine(HTable t) throws IOException {
        NavigableMap<HRegionInfo, ServerName> regions = t.getRegionLocations();
        for (Map.Entry e : regions.entrySet()) {
            byte[] startkey = ((HRegionInfo)e.getKey()).getStartKey();
            Scan s = new Scan(startkey);
            ResultScanner scanner = t.getScanner(s);
            Result r = scanner.next();
            Assert.assertTrue((r != null && r.size() > 0 ? 1 : 0) != 0);
            scanner.close();
        }
    }
}

