/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeCodec;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestPrefixTreeEncoding {
    private static final Log LOG = LogFactory.getLog(TestPrefixTreeEncoding.class);
    private static final String CF = "EncodingTestCF";
    private static final byte[] CF_BYTES = Bytes.toBytes("EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 50;
    private static final int NUM_COLS_PER_ROW = 20;
    private int numBatchesWritten = 0;
    private ConcurrentSkipListSet<KeyValue> kvset = new ConcurrentSkipListSet<Cell>(KeyValue.COMPARATOR);
    private static boolean formatRowNum = false;
    private final boolean includesTag;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{false});
        paramList.add(new Object[]{true});
        return paramList;
    }

    public TestPrefixTreeEncoding(boolean includesTag) {
        this.includesTag = includesTag;
    }

    @Before
    public void setUp() throws Exception {
        this.kvset.clear();
        formatRowNum = false;
    }

    @Test
    public void testSeekBeforeWithFixedData() throws Exception {
        formatRowNum = true;
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId, false, this.includesTag);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        encoder.encodeKeyValues(dataBuffer, blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer(readBuffer);
        KeyValue seekKey = KeyValue.createFirstDeleteFamilyOnRow(TestPrefixTreeEncoding.getRowKey(batchId, 0), CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertEquals(null, (Object)seeker.getKeyValue());
        seekKey = KeyValue.createFirstDeleteFamilyOnRow(TestPrefixTreeEncoding.getRowKey(batchId, 16), CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertNotNull((Object)seeker.getKeyValue());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 15), (byte[])seeker.getKeyValue().getRow());
        seekKey = KeyValue.createFirstDeleteFamilyOnRow(Bytes.toBytes("zzzz"), CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertNotNull((Object)seeker.getKeyValue());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 49), (byte[])seeker.getKeyValue().getRow());
    }

    @Test
    public void testScanWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateRandomTestData(this.kvset, this.numBatchesWritten++, this.includesTag);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        encoder.encodeKeyValues(dataBuffer, blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer(readBuffer);
        KeyValue previousKV = null;
        do {
            KeyValue currentKV = seeker.getKeyValue();
            System.out.println(currentKV);
            if (previousKV != null && KeyValue.COMPARATOR.compare(currentKV, previousKV) < 0) {
                this.dumpInputKVSet();
                Assert.fail((String)("Current kv " + currentKV + " is smaller than previous keyvalue " + previousKV));
            }
            if (!this.includesTag) {
                Assert.assertFalse((currentKV.getTagsLength() > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((currentKV.getTagsLength() > 0 ? 1 : 0) != 0);
            }
            previousKV = currentKV;
        } while (seeker.next());
    }

    @Test
    public void testSeekWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateRandomTestData(this.kvset, batchId, this.includesTag);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        encoder.encodeKeyValues(dataBuffer, blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    @Test
    public void testSeekWithFixedData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId, this.includesTag);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        encoder.encodeKeyValues(dataBuffer, blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    private void verifySeeking(DataBlockEncoder.EncodedSeeker encodeSeeker, ByteBuffer encodedData, int batchId) {
        ArrayList kvList = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            kvList.clear();
            encodeSeeker.setCurrentBuffer(encodedData);
            KeyValue firstOnRow = KeyValue.createFirstOnRow(TestPrefixTreeEncoding.getRowKey(batchId, i));
            encodeSeeker.seekToKeyInBlock(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength(), false);
            boolean hasMoreOfEncodeScanner = encodeSeeker.next();
            CollectionBackedScanner collectionScanner = new CollectionBackedScanner(this.kvset);
            boolean hasMoreOfCollectionScanner = collectionScanner.seek(firstOnRow);
            if (hasMoreOfEncodeScanner != hasMoreOfCollectionScanner) {
                this.dumpInputKVSet();
                Assert.fail((String)("Get error result after seeking " + firstOnRow));
            }
            if (!hasMoreOfEncodeScanner || KeyValue.COMPARATOR.compare(encodeSeeker.getKeyValue(), collectionScanner.peek()) == 0) continue;
            this.dumpInputKVSet();
            Assert.fail((String)("Expected " + collectionScanner.peek() + " actual " + encodeSeeker.getKeyValue() + ", after seeking " + firstOnRow));
        }
    }

    private void dumpInputKVSet() {
        LOG.info("Dumping input keyvalue set in error case:");
        for (KeyValue kv : this.kvset) {
            System.out.println(kv);
        }
    }

    private static ByteBuffer generateFixedTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId, boolean useTags) throws Exception {
        return TestPrefixTreeEncoding.generateFixedTestData(kvset, batchId, true, useTags);
    }

    private static ByteBuffer generateFixedTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId, boolean partial, boolean useTags) throws Exception {
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        for (int i = 0; i < 50; ++i) {
            if (partial && i / 10 % 2 == 1) continue;
            for (int j = 0; j < 20; ++j) {
                KeyValue kv;
                if (!useTags) {
                    kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                    kvset.add(kv);
                    continue;
                }
                kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), 0L, TestPrefixTreeEncoding.getValue(batchId, i, j), new Tag[]{new Tag(1, "metaValue1")});
                kvset.add(kv);
            }
        }
        for (KeyValue kv : kvset) {
            userDataStream.writeInt(kv.getKeyLength());
            userDataStream.writeInt(kv.getValueLength());
            userDataStream.write(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
            if (!useTags) continue;
            userDataStream.writeShort(kv.getTagsLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset() + kv.getValueLength() + 2, kv.getTagsLength());
        }
        return ByteBuffer.wrap(baosInMemory.toByteArray());
    }

    private static ByteBuffer generateRandomTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId, boolean useTags) throws Exception {
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        Random random = new Random();
        for (int i = 0; i < 50; ++i) {
            if (random.nextInt(100) < 50) continue;
            for (int j = 0; j < 20; ++j) {
                KeyValue kv;
                if (random.nextInt(100) < 50) continue;
                if (!useTags) {
                    kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                    kvset.add(kv);
                    continue;
                }
                kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), 0L, TestPrefixTreeEncoding.getValue(batchId, i, j), new Tag[]{new Tag(1, "metaValue1")});
                kvset.add(kv);
            }
        }
        for (KeyValue kv : kvset) {
            userDataStream.writeInt(kv.getKeyLength());
            userDataStream.writeInt(kv.getValueLength());
            userDataStream.write(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
            if (!useTags) continue;
            userDataStream.writeShort(kv.getTagsLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset() + kv.getValueLength() + 2, kv.getTagsLength());
        }
        return ByteBuffer.wrap(baosInMemory.toByteArray());
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes("batch" + batchId + "_row" + (formatRowNum ? String.format("%04d", i) : Integer.valueOf(i)));
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes("colfdfafhfhsdfhsdfh" + j);
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes("value_for_" + Bytes.toString(TestPrefixTreeEncoding.getRowKey(batchId, i)) + "_col" + j);
    }
}

