/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class CachedBlock
implements HeapSize,
Comparable<CachedBlock> {
    public static final long PER_BLOCK_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + ClassSize.STRING + ClassSize.BYTE_BUFFER);
    private final BlockCacheKey cacheKey;
    private final Cacheable buf;
    private volatile long accessTime;
    private long size;
    private BlockPriority priority;

    public CachedBlock(BlockCacheKey cacheKey, Cacheable buf, long accessTime) {
        this(cacheKey, buf, accessTime, false);
    }

    public CachedBlock(BlockCacheKey cacheKey, Cacheable buf, long accessTime, boolean inMemory) {
        this.cacheKey = cacheKey;
        this.buf = buf;
        this.accessTime = accessTime;
        this.size = ClassSize.align(cacheKey.heapSize()) + ClassSize.align(buf.heapSize()) + PER_BLOCK_OVERHEAD;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
    }

    public void access(long accessTime) {
        this.accessTime = accessTime;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    @Override
    public long heapSize() {
        return this.size;
    }

    @Override
    public int compareTo(CachedBlock that) {
        if (this.accessTime == that.accessTime) {
            return 0;
        }
        return this.accessTime < that.accessTime ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CachedBlock other = (CachedBlock)obj;
        return this.compareTo(other) == 0;
    }

    public Cacheable getBuffer() {
        return this.buf;
    }

    public BlockCacheKey getCacheKey() {
        return this.cacheKey;
    }

    public BlockPriority getPriority() {
        return this.priority;
    }

    static enum BlockPriority {
        SINGLE,
        MULTI,
        MEMORY;

    }
}

