/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.slab.SlabCache;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DoubleBlockCache
implements BlockCache,
HeapSize {
    static final Log LOG = LogFactory.getLog(DoubleBlockCache.class.getName());
    private final LruBlockCache onHeapCache;
    private final SlabCache offHeapCache;
    private final CacheStats stats;

    public DoubleBlockCache(long onHeapSize, long offHeapSize, long onHeapBlockSize, long offHeapBlockSize, Configuration conf) {
        LOG.info("Creating on-heap cache of size " + StringUtils.humanReadableInt(onHeapSize) + "bytes with an average block size of " + StringUtils.humanReadableInt(onHeapBlockSize) + " bytes.");
        this.onHeapCache = new LruBlockCache(onHeapSize, onHeapBlockSize, conf);
        LOG.info("Creating off-heap cache of size " + StringUtils.humanReadableInt(offHeapSize) + "bytes with an average block size of " + StringUtils.humanReadableInt(offHeapBlockSize) + " bytes.");
        this.offHeapCache = new SlabCache(offHeapSize, offHeapBlockSize);
        this.offHeapCache.addSlabByConf(conf);
        this.stats = new CacheStats();
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.onHeapCache.cacheBlock(cacheKey, buf, inMemory);
        this.offHeapCache.cacheBlock(cacheKey, buf);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.onHeapCache.cacheBlock(cacheKey, buf);
        this.offHeapCache.cacheBlock(cacheKey, buf);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat) {
        Cacheable cachedBlock = this.onHeapCache.getBlock(cacheKey, caching, repeat);
        if (cachedBlock != null) {
            this.stats.hit(caching);
            return cachedBlock;
        }
        cachedBlock = this.offHeapCache.getBlock(cacheKey, caching, repeat);
        if (cachedBlock != null) {
            if (caching) {
                this.onHeapCache.cacheBlock(cacheKey, cachedBlock);
            }
            this.stats.hit(caching);
            return cachedBlock;
        }
        if (!repeat) {
            this.stats.miss(caching);
        }
        return null;
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        boolean evicted;
        this.stats.evict();
        boolean cacheA = this.onHeapCache.evictBlock(cacheKey);
        boolean cacheB = this.offHeapCache.evictBlock(cacheKey);
        boolean bl = evicted = cacheA || cacheB;
        if (evicted) {
            this.stats.evicted();
        }
        return evicted;
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public void shutdown() {
        this.onHeapCache.shutdown();
        this.offHeapCache.shutdown();
    }

    @Override
    public long heapSize() {
        return this.onHeapCache.heapSize() + this.offHeapCache.heapSize();
    }

    @Override
    public long size() {
        return this.onHeapCache.size() + this.offHeapCache.size();
    }

    @Override
    public long getFreeSize() {
        return this.onHeapCache.getFreeSize() + this.offHeapCache.getFreeSize();
    }

    @Override
    public long getCurrentSize() {
        return this.onHeapCache.getCurrentSize() + this.offHeapCache.getCurrentSize();
    }

    @Override
    public long getEvictedCount() {
        return this.onHeapCache.getEvictedCount() + this.offHeapCache.getEvictedCount();
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        this.onHeapCache.evictBlocksByHfileName(hfileName);
        this.offHeapCache.evictBlocksByHfileName(hfileName);
        return 0;
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries(Configuration conf) throws IOException {
        return this.onHeapCache.getBlockCacheColumnFamilySummaries(conf);
    }

    @Override
    public long getBlockCount() {
        return this.onHeapCache.getBlockCount() + this.offHeapCache.getBlockCount();
    }
}

