/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.HashMap;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBlockCacheColumnFamilySummary {
    @Test
    public void testEquals() {
        BlockCacheColumnFamilySummary e1 = new BlockCacheColumnFamilySummary();
        e1.setTable("table1");
        e1.setColumnFamily("cf1");
        BlockCacheColumnFamilySummary e2 = new BlockCacheColumnFamilySummary();
        e2.setTable("table1");
        e2.setColumnFamily("cf1");
        Assert.assertEquals((String)"bcse", (Object)e1, (Object)e2);
    }

    @Test
    public void testNotEquals() {
        BlockCacheColumnFamilySummary e1 = new BlockCacheColumnFamilySummary();
        e1.setTable("table1");
        e1.setColumnFamily("cf1");
        BlockCacheColumnFamilySummary e2 = new BlockCacheColumnFamilySummary();
        e2.setTable("tablexxxxxx");
        e2.setColumnFamily("cf1");
        Assert.assertTrue((String)"bcse", (!e1.equals(e2) ? 1 : 0) != 0);
    }

    @Test
    public void testMapLookup() {
        HashMap<BlockCacheColumnFamilySummary, BlockCacheColumnFamilySummary> bcs = new HashMap<BlockCacheColumnFamilySummary, BlockCacheColumnFamilySummary>();
        BlockCacheColumnFamilySummary e1 = new BlockCacheColumnFamilySummary("table1", "cf1");
        BlockCacheColumnFamilySummary lookup = (BlockCacheColumnFamilySummary)bcs.get(e1);
        if (lookup == null) {
            lookup = BlockCacheColumnFamilySummary.create(e1);
            bcs.put(e1, lookup);
            lookup.incrementBlocks();
            lookup.incrementHeapSize(100L);
        }
        BlockCacheColumnFamilySummary e2 = new BlockCacheColumnFamilySummary("table1", "cf1");
        BlockCacheColumnFamilySummary l2 = (BlockCacheColumnFamilySummary)bcs.get(e2);
        Assert.assertEquals((String)"blocks", (long)1L, (long)l2.getBlocks());
        Assert.assertEquals((String)"heap", (long)100L, (long)l2.getHeapSize());
    }

    @Test
    public void testMapEntry() {
        HashMap<BlockCacheColumnFamilySummary, BlockCacheColumnFamilySummary> bcs = new HashMap<BlockCacheColumnFamilySummary, BlockCacheColumnFamilySummary>();
        BlockCacheColumnFamilySummary e1 = new BlockCacheColumnFamilySummary("table1", "cf1");
        bcs.put(e1, e1);
        BlockCacheColumnFamilySummary e2 = new BlockCacheColumnFamilySummary("table1", "cf1");
        bcs.put(e2, e2);
        BlockCacheColumnFamilySummary e3 = new BlockCacheColumnFamilySummary("table1", "cf1");
        bcs.put(e3, e3);
        Assert.assertEquals((String)"mapSize", (long)1L, (long)bcs.size());
    }
}

