/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.test.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestHFileDataBlockEncoder {
    private HFileDataBlockEncoderImpl blockEncoder;
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private boolean includesMemstoreTS;

    public TestHFileDataBlockEncoder(HFileDataBlockEncoderImpl blockEncoder, boolean includesMemstoreTS) {
        this.blockEncoder = blockEncoder;
        this.includesMemstoreTS = includesMemstoreTS;
        System.err.println("Encoding: " + (Object)((Object)blockEncoder.getDataBlockEncoding()) + ", includesMemstoreTS: " + includesMemstoreTS);
    }

    @Test
    public void testEncodingWithCache() throws IOException {
        this.testEncodingWithCacheInternals(false);
        this.testEncodingWithCacheInternals(true);
    }

    private void testEncodingWithCacheInternals(boolean useTag) throws IOException {
        HFileBlock block = this.getSampleHFileBlock(useTag);
        HFileBlock cacheBlock = this.createBlockOnDisk(block, useTag);
        LruBlockCache blockCache = new LruBlockCache(0x800000L, 32768L);
        BlockCacheKey cacheKey = new BlockCacheKey("test", 0L);
        blockCache.cacheBlock(cacheKey, cacheBlock);
        Cacheable heapSize = blockCache.getBlock(cacheKey, false, false);
        Assert.assertTrue((boolean)(heapSize instanceof HFileBlock));
        HFileBlock returnedBlock = (HFileBlock)heapSize;
        if (this.blockEncoder.getDataBlockEncoding() == DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)block.getBufferWithHeader(), (Object)returnedBlock.getBufferWithHeader());
        } else {
            if (BlockType.ENCODED_DATA != returnedBlock.getBlockType()) {
                System.out.println(this.blockEncoder);
            }
            Assert.assertEquals((Object)((Object)BlockType.ENCODED_DATA), (Object)((Object)returnedBlock.getBlockType()));
        }
    }

    @Test
    public void testHeaderSizeInCacheWithoutChecksum() throws Exception {
        this.testHeaderSizeInCacheWithoutChecksumInternals(false);
        this.testHeaderSizeInCacheWithoutChecksumInternals(true);
    }

    private void testHeaderSizeInCacheWithoutChecksumInternals(boolean useTags) throws IOException {
        int headerSize = 24;
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer(this.generator.generateTestKeyValues(60, useTags), this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + headerSize);
        buf.position(headerSize);
        keyValues.rewind();
        buf.put(keyValues);
        HFileContext hfileContext = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(useTags).withBlockSize(0).withChecksumType(ChecksumType.NULL).build();
        HFileBlock block = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, 0, hfileContext);
        HFileBlock cacheBlock = this.createBlockOnDisk(block, useTags);
        Assert.assertEquals((long)headerSize, (long)cacheBlock.getDummyHeaderForVersion().length);
    }

    private HFileBlock createBlockOnDisk(HFileBlock block, boolean useTags) throws IOException {
        HFileBlockDefaultEncodingContext context = new HFileBlockDefaultEncodingContext(this.blockEncoder.getDataBlockEncoding(), HConstants.HFILEBLOCK_DUMMY_HEADER, block.getHFileContext());
        context.setDummyHeader(block.getDummyHeaderForVersion());
        this.blockEncoder.beforeWriteToDisk(block.getBufferWithoutHeader(), context, block.getBlockType());
        byte[] encodedBytes = context.getUncompressedBytesWithHeader();
        int size = encodedBytes.length - block.getDummyHeaderForVersion().length;
        return new HFileBlock(context.getBlockType(), size, size, -1L, ByteBuffer.wrap(encodedBytes), true, 0L, block.getOnDiskDataSizeWithHeader(), block.getHFileContext());
    }

    @Test
    public void testEncoding() throws IOException {
        this.testEncodingInternals(false);
        this.testEncodingInternals(true);
    }

    private void testEncodingInternals(boolean useTag) throws IOException {
        HFileBlock block = this.getSampleHFileBlock(useTag);
        HFileBlock blockOnDisk = this.createBlockOnDisk(block, useTag);
        if (this.blockEncoder.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)((Object)BlockType.ENCODED_DATA), (Object)((Object)blockOnDisk.getBlockType()));
            Assert.assertEquals((long)this.blockEncoder.getDataBlockEncoding().getId(), (long)blockOnDisk.getDataBlockEncodingId());
        } else {
            Assert.assertEquals((Object)((Object)BlockType.DATA), (Object)((Object)blockOnDisk.getBlockType()));
        }
    }

    private HFileBlock getSampleHFileBlock(boolean useTag) {
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer(this.generator.generateTestKeyValues(60, useTag), this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + 33);
        buf.position(33);
        keyValues.rewind();
        buf.put(keyValues);
        HFileContext meta = new HFileContextBuilder().withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(useTag).withHBaseCheckSum(true).withCompression(Compression.Algorithm.NONE).withBlockSize(0).withChecksumType(ChecksumType.NULL).build();
        HFileBlock b = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, 0, meta);
        return b;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getAllConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (DataBlockEncoding diskAlgo : DataBlockEncoding.values()) {
            for (boolean includesMemstoreTS : new boolean[]{false, true}) {
                configurations.add(new Object[]{new HFileDataBlockEncoderImpl(diskAlgo), new Boolean(includesMemstoreTS)});
            }
        }
        return configurations;
    }
}

