/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.ToolRunner;

public class TestHFilePerformance
extends AbstractHBaseTool {
    private HBaseTestingUtility TEST_UTIL;
    private static String ROOT_DIR;
    private FileSystem fs;
    private long startTimeEpoch;
    private long finishTimeEpoch;
    private DateFormat formatter;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.fs = FileSystem.get(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.TEST_UTIL = new HBaseTestingUtility(conf);
        ROOT_DIR = this.TEST_UTIL.getDataTestDir("TestHFilePerformance").toString();
    }

    public void startTime() {
        this.startTimeEpoch = System.currentTimeMillis();
        System.out.println(this.formatTime() + " Started timing.");
    }

    public void stopTime() {
        this.finishTimeEpoch = System.currentTimeMillis();
        System.out.println(this.formatTime() + " Stopped timing.");
    }

    public long getIntervalMillis() {
        return this.finishTimeEpoch - this.startTimeEpoch;
    }

    public void printlnWithTimestamp(String message) {
        System.out.println(this.formatTime() + "  " + message);
    }

    public String formatTime(long milis) {
        return this.formatter.format(milis);
    }

    public String formatTime() {
        return this.formatTime(System.currentTimeMillis());
    }

    private FSDataOutputStream createFSOutput(Path name) throws IOException {
        if (this.fs.exists(name)) {
            this.fs.delete(name, true);
        }
        FSDataOutputStream fout = this.fs.create(name);
        return fout;
    }

    public void timeWrite(String fileType, int keyLength, int valueLength, String codecName, String cipherName, long rows, String writeMethod, int minBlockSize) throws IOException {
        System.out.println("File Type: " + fileType);
        System.out.println("Writing " + fileType + " with codecName: " + codecName + " cipherName: " + cipherName);
        long totalBytesWritten = 0L;
        byte[] key = new byte[keyLength];
        byte[] value = new byte[valueLength];
        KeyValueGenerator generator = new KeyValueGenerator();
        this.startTime();
        Path path = new Path(ROOT_DIR, fileType + ".Performance");
        System.out.println(ROOT_DIR + path.getName());
        FSDataOutputStream fout = this.createFSOutput(path);
        if ("HFile".equals(fileType)) {
            HFileContextBuilder builder = new HFileContextBuilder().withCompression(AbstractHFileWriter.compressionByName(codecName)).withBlockSize(minBlockSize);
            if (cipherName != "none") {
                byte[] cipherKey = new byte[16];
                new SecureRandom().nextBytes(cipherKey);
                builder.withEncryptionContext(Encryption.newContext(this.conf).setCipher(Encryption.getCipher(this.conf, cipherName)).setKey(cipherKey));
            }
            HFileContext context = builder.build();
            System.out.println("HFile write method: ");
            HFile.Writer writer = HFile.getWriterFactoryNoCache(this.conf).withOutputStream(fout).withFileContext(context).withComparator(new KeyValue.RawBytesComparator()).create();
            for (long l = 0L; l < rows; ++l) {
                generator.getKey(key);
                generator.getValue(value);
                writer.append(key, value);
                totalBytesWritten += (long)key.length;
                totalBytesWritten += (long)value.length;
            }
            writer.close();
        } else if ("SequenceFile".equals(fileType)) {
            GzipCodec codec = null;
            if ("gz".equals(codecName)) {
                codec = new GzipCodec();
            } else if (!"none".equals(codecName)) {
                throw new IOException("Codec not supported.");
            }
            SequenceFile.Writer writer = !"none".equals(codecName) ? SequenceFile.createWriter(this.conf, fout, BytesWritable.class, BytesWritable.class, SequenceFile.CompressionType.BLOCK, codec) : SequenceFile.createWriter(this.conf, fout, BytesWritable.class, BytesWritable.class, SequenceFile.CompressionType.NONE, null);
            for (long l = 0L; l < rows; ++l) {
                generator.getKey(key);
                BytesWritable keyBsw = new BytesWritable(key);
                totalBytesWritten += (long)keyBsw.getSize();
                generator.getValue(value);
                BytesWritable valBsw = new BytesWritable(value);
                writer.append(keyBsw, valBsw);
                totalBytesWritten += (long)valBsw.getSize();
            }
            writer.close();
        } else {
            throw new IOException("File Type is not supported");
        }
        fout.close();
        this.stopTime();
        this.printlnWithTimestamp("Data written: ");
        this.printlnWithTimestamp("  rate  = " + totalBytesWritten / this.getIntervalMillis() * 1000L / 1024L / 1024L + "MB/s");
        this.printlnWithTimestamp("  total = " + totalBytesWritten + "B");
        this.printlnWithTimestamp("File written: ");
        this.printlnWithTimestamp("  rate  = " + this.fs.getFileStatus(path).getLen() / this.getIntervalMillis() * 1000L / 1024L / 1024L + "MB/s");
        this.printlnWithTimestamp("  total = " + this.fs.getFileStatus(path).getLen() + "B");
    }

    public void timeReading(String fileType, int keyLength, int valueLength, long rows, int method) throws IOException {
        System.out.println("Reading file of type: " + fileType);
        Path path = new Path(ROOT_DIR, fileType + ".Performance");
        System.out.println("Input file size: " + this.fs.getFileStatus(path).getLen());
        long totalBytesRead = 0L;
        this.startTime();
        FSDataInputStream fin = this.fs.open(path);
        if ("HFile".equals(fileType)) {
            HFile.Reader reader = HFile.createReaderFromStream(path, this.fs.open(path), this.fs.getFileStatus(path).getLen(), new CacheConfig(this.conf), this.conf);
            reader.loadFileInfo();
            switch (method) {
                default: 
            }
            HFileScanner scanner = reader.getScanner(false, false);
            scanner.seekTo();
            for (long l = 0L; l < rows; ++l) {
                ByteBuffer key = scanner.getKey();
                ByteBuffer val = scanner.getValue();
                totalBytesRead += (long)(key.limit() + val.limit());
                scanner.next();
            }
            reader.close();
        } else if ("SequenceFile".equals(fileType)) {
            SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, path, new Configuration());
            if (reader.getCompressionCodec() != null) {
                this.printlnWithTimestamp("Compression codec class: " + reader.getCompressionCodec().getClass());
            } else {
                this.printlnWithTimestamp("Compression codec class: none");
            }
            BytesWritable keyBsw = new BytesWritable();
            BytesWritable valBsw = new BytesWritable();
            for (long l = 0L; l < rows; ++l) {
                reader.next(keyBsw, valBsw);
                totalBytesRead += (long)(keyBsw.getSize() + valBsw.getSize());
            }
            reader.close();
        } else {
            throw new IOException("File Type not supported.");
        }
        fin.close();
        this.stopTime();
        this.printlnWithTimestamp("Finished in " + this.getIntervalMillis() + "ms");
        this.printlnWithTimestamp("Data read: ");
        this.printlnWithTimestamp("  rate  = " + totalBytesRead / this.getIntervalMillis() * 1000L / 1024L / 1024L + "MB/s");
        this.printlnWithTimestamp("  total = " + totalBytesRead + "B");
        this.printlnWithTimestamp("File read: ");
        this.printlnWithTimestamp("  rate  = " + this.fs.getFileStatus(path).getLen() / this.getIntervalMillis() * 1000L / 1024L / 1024L + "MB/s");
        this.printlnWithTimestamp("  total = " + this.fs.getFileStatus(path).getLen() + "B");
    }

    public void testRunComparisons() throws IOException {
        int keyLength = 100;
        int valueLength = 5120;
        int minBlockSize = 0xA00000;
        int rows = 10000;
        System.out.println("****************************** Sequence File *****************************");
        this.timeWrite("SequenceFile", keyLength, valueLength, "none", "none", rows, null, minBlockSize);
        System.out.println("\n+++++++\n");
        this.timeReading("SequenceFile", keyLength, valueLength, rows, -1);
        System.out.println("");
        System.out.println("----------------------");
        System.out.println("");
        try {
            this.timeWrite("SequenceFile", keyLength, valueLength, "gz", "none", rows, null, minBlockSize);
            System.out.println("\n+++++++\n");
            this.timeReading("SequenceFile", keyLength, valueLength, rows, -1);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Skipping sequencefile gz: " + e.getMessage());
        }
        System.out.println("\n\n\n");
        System.out.println("****************************** HFile *****************************");
        this.timeWrite("HFile", keyLength, valueLength, "none", "none", rows, null, minBlockSize);
        System.out.println("\n+++++++\n");
        this.timeReading("HFile", keyLength, valueLength, rows, 0);
        System.out.println("");
        System.out.println("----------------------");
        System.out.println("");
        this.timeWrite("HFile", keyLength, valueLength, "none", "aes", rows, null, minBlockSize);
        System.out.println("\n+++++++\n");
        this.timeReading("HFile", keyLength, valueLength, rows, 0);
        System.out.println("");
        System.out.println("----------------------");
        System.out.println("");
        this.timeWrite("HFile", keyLength, valueLength, "gz", "none", rows, null, minBlockSize);
        System.out.println("\n+++++++\n");
        this.timeReading("HFile", keyLength, valueLength, rows, 0);
        System.out.println("");
        System.out.println("----------------------");
        System.out.println("");
        this.timeWrite("HFile", keyLength, valueLength, "gz", "aes", rows, null, minBlockSize);
        System.out.println("\n+++++++\n");
        this.timeReading("HFile", keyLength, valueLength, rows, 0);
        System.out.println("\n\n\n\nNotes: ");
        System.out.println(" * Timing includes open/closing of files.");
        System.out.println(" * Timing includes reading both Key and Value");
        System.out.println(" * Data is generated as random bytes. Other methods e.g. using dictionary with care for distributation of words is under development.");
        System.out.println(" * Timing of write currently, includes random value/key generations. Which is the same for Sequence File and HFile. Another possibility is to generate test data beforehand");
        System.out.println(" * We need to mitigate cache effect on benchmark. We can apply several ideas, for next step we do a large dummy read between benchmark read to dismantle caching of data. Renaming of file may be helpful. We can have a loop that reads with the same method several times and flood cache every time and average it to get a better number.");
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
    }

    @Override
    protected int doWork() throws Exception {
        this.testRunComparisons();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run(HBaseConfiguration.create(), new TestHFilePerformance(), args);
        System.exit(ret);
    }

    private static class KeyValueGenerator {
        Random keyRandomizer = new Random(0L);
        Random valueRandomizer = new Random(1L);
        long randomValueRatio = 3L;
        long valueSequence = 0L;

        KeyValueGenerator() {
        }

        void getKey(byte[] key) {
            this.keyRandomizer.nextBytes(key);
        }

        void getValue(byte[] value) {
            if (this.valueSequence % this.randomValueRatio == 0L) {
                this.valueRandomizer.nextBytes(value);
            }
            ++this.valueSequence;
        }
    }
}

