/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.KVGenerator;
import org.apache.hadoop.hbase.io.hfile.KeySampler;
import org.apache.hadoop.hbase.io.hfile.NanoTimer;
import org.apache.hadoop.hbase.io.hfile.RandomDistribution;
import org.apache.hadoop.io.BytesWritable;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHFileSeek
extends TestCase {
    private static final boolean USE_PREAD = true;
    private MyOptions options;
    private Configuration conf;
    private Path path;
    private FileSystem fs;
    private NanoTimer timer;
    private Random rng;
    private RandomDistribution.DiscreteRNG keyLenGen;
    private KVGenerator kvGen;
    private static final Log LOG = LogFactory.getLog(TestHFileSeek.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    public void setUp() throws IOException {
        if (this.options == null) {
            this.options = new MyOptions(new String[0]);
        }
        this.conf = new Configuration();
        if (this.options.useRawFs) {
            this.conf.setClass("fs.file.impl", RawLocalFileSystem.class, FileSystem.class);
        }
        this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSize);
        this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSize);
        this.path = new Path(new Path(this.options.rootDir), this.options.file);
        this.fs = this.path.getFileSystem(this.conf);
        this.timer = new NanoTimer(false);
        this.rng = new Random(this.options.seed);
        this.keyLenGen = new RandomDistribution.Zipf(new Random(this.rng.nextLong()), this.options.minKeyLen, this.options.maxKeyLen, 1.2);
        RandomDistribution.Flat valLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minValLength, this.options.maxValLength);
        RandomDistribution.Flat wordLenGen = new RandomDistribution.Flat(new Random(this.rng.nextLong()), this.options.minWordLen, this.options.maxWordLen);
        this.kvGen = new KVGenerator(this.rng, true, this.keyLenGen, valLenGen, wordLenGen, this.options.dictSize);
    }

    public void tearDown() {
        try {
            this.fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static FSDataOutputStream createFSOutput(Path name, FileSystem fs) throws IOException {
        if (fs.exists(name)) {
            fs.delete(name, true);
        }
        FSDataOutputStream fout = fs.create(name);
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTFile() throws IOException {
        long totalBytes = 0L;
        FSDataOutputStream fout = TestHFileSeek.createFSOutput(this.path, this.fs);
        try {
            HFileContext context = new HFileContextBuilder().withBlockSize(this.options.minBlockSize).withCompression(AbstractHFileWriter.compressionByName(this.options.compress)).build();
            HFile.Writer writer = HFile.getWriterFactoryNoCache(this.conf).withOutputStream(fout).withFileContext(context).withComparator(new KeyValue.RawBytesComparator()).create();
            try {
                BytesWritable key = new BytesWritable();
                BytesWritable val = new BytesWritable();
                this.timer.start();
                long i = 0L;
                while (i % 1000L != 0L || this.fs.getFileStatus(this.path).getLen() < this.options.fileSize) {
                    this.kvGen.next(key, val, false);
                    byte[] k = new byte[key.getLength()];
                    System.arraycopy(key.getBytes(), 0, k, 0, key.getLength());
                    byte[] v = new byte[val.getLength()];
                    System.arraycopy(val.getBytes(), 0, v, 0, key.getLength());
                    writer.append(k, v);
                    totalBytes += (long)key.getLength();
                    totalBytes += (long)val.getLength();
                    ++i;
                }
                this.timer.stop();
            }
            finally {
                writer.close();
            }
        }
        finally {
            fout.close();
        }
        double duration = (double)this.timer.read() / 1000.0;
        long fsize = this.fs.getFileStatus(this.path).getLen();
        System.out.printf("time: %s...uncompressed: %.2fMB...raw thrpt: %.2fMB/s\n", this.timer.toString(), (double)totalBytes / 1024.0 / 1024.0, (double)totalBytes / duration);
        System.out.printf("time: %s...file size: %.2fMB...disk thrpt: %.2fMB/s\n", this.timer.toString(), (double)fsize / 1024.0 / 1024.0, (double)fsize / duration);
    }

    public void seekTFile() throws IOException {
        int miss = 0;
        long totalBytes = 0L;
        FSDataInputStream fsdis = this.fs.open(this.path);
        HFile.Reader reader = HFile.createReaderFromStream(this.path, fsdis, this.fs.getFileStatus(this.path).getLen(), new CacheConfig(this.conf), this.conf);
        reader.loadFileInfo();
        KeySampler kSampler = new KeySampler(this.rng, reader.getFirstKey(), reader.getLastKey(), this.keyLenGen);
        HFileScanner scanner = reader.getScanner(false, true);
        BytesWritable key = new BytesWritable();
        this.timer.reset();
        this.timer.start();
        int i = 0;
        while ((long)i < this.options.seekCount) {
            kSampler.next(key);
            byte[] k = new byte[key.getLength()];
            System.arraycopy(key.getBytes(), 0, k, 0, key.getLength());
            if (scanner.seekTo(k) >= 0) {
                ByteBuffer bbkey = scanner.getKey();
                ByteBuffer bbval = scanner.getValue();
                totalBytes += (long)bbkey.limit();
                totalBytes += (long)bbval.limit();
            } else {
                ++miss;
            }
            ++i;
        }
        this.timer.stop();
        System.out.printf("time: %s...avg seek: %s...%d hit...%d miss...avg I/O size: %.2fKB\n", this.timer.toString(), NanoTimer.nanoTimeToString(this.timer.read() / this.options.seekCount), this.options.seekCount - (long)miss, miss, (double)totalBytes / 1024.0 / (double)(this.options.seekCount - (long)miss));
    }

    public void testSeeks() throws IOException {
        if (this.options.doCreate()) {
            this.createTFile();
        }
        if (this.options.doRead()) {
            this.seekTFile();
        }
        if (this.options.doCreate()) {
            this.fs.delete(this.path, true);
        }
    }

    public static void main(String[] argv) throws IOException {
        TestHFileSeek testCase = new TestHFileSeek();
        MyOptions options = new MyOptions(argv);
        if (!options.proceed) {
            return;
        }
        testCase.options = options;
        int i = 0;
        while ((long)i < options.trialCount) {
            LOG.info("Beginning trial " + (i + 1));
            testCase.setUp();
            testCase.testSeeks();
            testCase.tearDown();
            ++i;
        }
    }

    private static class MyOptions {
        int dictSize = 1000;
        int minWordLen = 5;
        int maxWordLen = 20;
        private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        String rootDir = this.TEST_UTIL.getDataTestDir("TestTFileSeek").toString();
        String file = "TestTFileSeek";
        String compress = "none";
        int minKeyLen = 10;
        int maxKeyLen = 50;
        int minValLength = 1024;
        int maxValLength = 2048;
        int minBlockSize = 0x100000;
        int fsOutputBufferSize = 1;
        int fsInputBufferSize = 0;
        long fileSize = 0xA00000L;
        long seekCount = 1000L;
        long trialCount = 1L;
        long seed = System.nanoTime();
        boolean useRawFs = false;
        static final int OP_CREATE = 1;
        static final int OP_READ = 2;
        int op = 3;
        boolean proceed = false;

        public MyOptions(String[] args) {
            try {
                Options opts = this.buildOptions();
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(opts, args, true);
                this.processOptions(line, opts);
                this.validateOptions();
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                System.out.println("Try \"--help\" option for details.");
                this.setStopProceed();
            }
        }

        public boolean proceed() {
            return this.proceed;
        }

        private Options buildOptions() {
            OptionBuilder.withLongOpt("compress");
            OptionBuilder.withArgName("[none|lzo|gz|snappy]");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("compression scheme");
            Option compress = OptionBuilder.create('c');
            OptionBuilder.withLongOpt("file-size");
            OptionBuilder.withArgName("size-in-MB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("target size of the file (in MB).");
            Option fileSize = OptionBuilder.create('s');
            OptionBuilder.withLongOpt("fs-input-buffer");
            OptionBuilder.withArgName("size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("size of the file system input buffer (in bytes).");
            Option fsInputBufferSz = OptionBuilder.create('i');
            OptionBuilder.withLongOpt("fs-output-buffer");
            OptionBuilder.withArgName("size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("size of the file system output buffer (in bytes).");
            Option fsOutputBufferSize = OptionBuilder.create('o');
            OptionBuilder.withLongOpt("key-length");
            OptionBuilder.withArgName("min,max");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("the length range of the key (in bytes)");
            Option keyLen = OptionBuilder.create('k');
            OptionBuilder.withLongOpt("value-length");
            OptionBuilder.withArgName("min,max");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("the length range of the value (in bytes)");
            Option valueLen = OptionBuilder.create('v');
            OptionBuilder.withLongOpt("block");
            OptionBuilder.withArgName("size-in-KB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("minimum block size (in KB)");
            Option blockSz = OptionBuilder.create('b');
            OptionBuilder.withLongOpt("operation");
            OptionBuilder.withArgName("r|w|rw");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("action: seek-only, create-only, seek-after-create");
            Option operation = OptionBuilder.create('x');
            OptionBuilder.withLongOpt("root-dir");
            OptionBuilder.withArgName("path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("specify root directory where files will be created.");
            Option rootDir = OptionBuilder.create('r');
            OptionBuilder.withLongOpt("file");
            OptionBuilder.withArgName("name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("specify the file name to be created or read.");
            Option file = OptionBuilder.create('f');
            OptionBuilder.withLongOpt("seek");
            OptionBuilder.withArgName("count");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("specify how many seek operations we perform (requires -x r or -x rw.");
            Option seekCount = OptionBuilder.create('n');
            OptionBuilder.withLongOpt("trials");
            OptionBuilder.withArgName("n");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("specify how many times to run the whole benchmark");
            Option trialCount = OptionBuilder.create('t');
            OptionBuilder.withLongOpt("rawfs");
            OptionBuilder.withDescription("use raw instead of checksummed file system");
            Option useRawFs = OptionBuilder.create();
            OptionBuilder.withLongOpt("help");
            OptionBuilder.hasArg(false);
            OptionBuilder.withDescription("show this screen");
            Option help = OptionBuilder.create("h");
            return new Options().addOption(compress).addOption(fileSize).addOption(fsInputBufferSz).addOption(fsOutputBufferSize).addOption(keyLen).addOption(blockSz).addOption(rootDir).addOption(valueLen).addOption(operation).addOption(seekCount).addOption(file).addOption(trialCount).addOption(useRawFs).addOption(help);
        }

        private void processOptions(CommandLine line, Options opts) throws ParseException {
            IntegerRange ir;
            if (line.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                System.out.println("TFile and SeqFile benchmark.");
                System.out.println();
                formatter.printHelp(100, "java ... TestTFileSeqFileComparison [options]", "\nSupported options:", opts, "");
                return;
            }
            if (line.hasOption('c')) {
                this.compress = line.getOptionValue('c');
            }
            if (line.hasOption('d')) {
                this.dictSize = Integer.parseInt(line.getOptionValue('d'));
            }
            if (line.hasOption('s')) {
                this.fileSize = Long.parseLong(line.getOptionValue('s')) * 1024L * 1024L;
            }
            if (line.hasOption('i')) {
                this.fsInputBufferSize = Integer.parseInt(line.getOptionValue('i'));
            }
            if (line.hasOption('o')) {
                this.fsOutputBufferSize = Integer.parseInt(line.getOptionValue('o'));
            }
            if (line.hasOption('n')) {
                this.seekCount = Integer.parseInt(line.getOptionValue('n'));
            }
            if (line.hasOption('t')) {
                this.trialCount = Integer.parseInt(line.getOptionValue('t'));
            }
            if (line.hasOption('k')) {
                ir = IntegerRange.parse(line.getOptionValue('k'));
                this.minKeyLen = ir.from();
                this.maxKeyLen = ir.to();
            }
            if (line.hasOption('v')) {
                ir = IntegerRange.parse(line.getOptionValue('v'));
                this.minValLength = ir.from();
                this.maxValLength = ir.to();
            }
            if (line.hasOption('b')) {
                this.minBlockSize = Integer.parseInt(line.getOptionValue('b')) * 1024;
            }
            if (line.hasOption('r')) {
                this.rootDir = line.getOptionValue('r');
            }
            if (line.hasOption('f')) {
                this.file = line.getOptionValue('f');
            }
            if (line.hasOption('S')) {
                this.seed = Long.parseLong(line.getOptionValue('S'));
            }
            if (line.hasOption('x')) {
                String strOp = line.getOptionValue('x');
                if (strOp.equals("r")) {
                    this.op = 2;
                } else if (strOp.equals("w")) {
                    this.op = 1;
                } else if (strOp.equals("rw")) {
                    this.op = 3;
                } else {
                    throw new ParseException("Unknown action specifier: " + strOp);
                }
            }
            this.useRawFs = line.hasOption("rawfs");
            this.proceed = true;
        }

        private void validateOptions() throws ParseException {
            if (!(this.compress.equals("none") || this.compress.equals("lzo") || this.compress.equals("gz") || this.compress.equals("snappy"))) {
                throw new ParseException("Unknown compression scheme: " + this.compress);
            }
            if (this.minKeyLen >= this.maxKeyLen) {
                throw new ParseException("Max key length must be greater than min key length.");
            }
            if (this.minValLength >= this.maxValLength) {
                throw new ParseException("Max value length must be greater than min value length.");
            }
            if (this.minWordLen >= this.maxWordLen) {
                throw new ParseException("Max word length must be greater than min word length.");
            }
        }

        private void setStopProceed() {
            this.proceed = false;
        }

        public boolean doCreate() {
            return (this.op & 1) != 0;
        }

        public boolean doRead() {
            return (this.op & 2) != 0;
        }
    }

    private static class IntegerRange {
        private final int from;
        private final int to;

        public IntegerRange(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public static IntegerRange parse(String s) throws ParseException {
            StringTokenizer st = new StringTokenizer(s, " \t,");
            if (st.countTokens() != 2) {
                throw new ParseException("Bad integer specification: " + s);
            }
            int from = Integer.parseInt(st.nextToken());
            int to = Integer.parseInt(st.nextToken());
            return new IntegerRange(from, to);
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }
    }
}

