/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV3;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestHFileWriterV3 {
    private static final Log LOG = LogFactory.getLog(TestHFileWriterV3.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private boolean useTags;

    public TestHFileWriterV3(boolean useTags) {
        this.useTags = useTags;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get(this.conf);
    }

    @Test
    public void testHFileFormatV3() throws IOException {
        this.testHFileFormatV3Internals(this.useTags);
    }

    private void testHFileFormatV3Internals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        Compression.Algorithm compressAlgo = Compression.Algorithm.GZ;
        int entryCount = 10000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, 10000, false, useTags);
    }

    @Test
    public void testMidKeyInHFile() throws IOException {
        this.testMidKeyInHFileInternals(this.useTags);
    }

    private void testMidKeyInHFileInternals(boolean useTags) throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testMidKeyInHFile");
        Compression.Algorithm compressAlgo = Compression.Algorithm.NONE;
        int entryCount = 50000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, entryCount, true, useTags);
    }

    private void writeDataAndReadFromHFile(Path hfilePath, Compression.Algorithm compressAlgo, int entryCount, boolean findMidKey, boolean useTags) throws IOException {
        long curBlockPos;
        HFileBlock block;
        HFileContext context = new HFileContextBuilder().withBlockSize(4096).withIncludesTags(useTags).withCompression(compressAlgo).build();
        HFileWriterV3 writer = (HFileWriterV3)new HFileWriterV3.WriterFactoryV3(this.conf, new CacheConfig(this.conf)).withPath(this.fs, hfilePath).withFileContext(context).withComparator(KeyValue.COMPARATOR).create();
        Random rand = new Random(9713312L);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = TestHFileWriterV2.randomOrderedKey(rand, i);
            byte[] valueBytes = TestHFileWriterV2.randomValue(rand);
            KeyValue keyValue = null;
            if (useTags) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (int j = 0; j < 1 + rand.nextInt(4); ++j) {
                    byte[] tagBytes = new byte[16];
                    rand.nextBytes(tagBytes);
                    tags.add(new Tag(1, tagBytes));
                }
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes, tags);
            } else {
                keyValue = new KeyValue(keyBytes, null, null, Long.MAX_VALUE, valueBytes);
            }
            writer.append(keyValue);
            keyValues.add(keyValue);
        }
        writer.appendMetaBlock("CAPITAL_OF_USA", new Text("Washington, D.C."));
        writer.appendMetaBlock("CAPITAL_OF_RUSSIA", new Text("Moscow"));
        writer.appendMetaBlock("CAPITAL_OF_FRANCE", new Text("Paris"));
        writer.close();
        FSDataInputStream fsdis = this.fs.open(hfilePath);
        long fileSize = this.fs.getFileStatus(hfilePath).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis, fileSize);
        Assert.assertEquals((long)3L, (long)trailer.getMajorVersion());
        Assert.assertEquals((long)entryCount, (long)trailer.getEntryCount());
        HFileContext meta = new HFileContextBuilder().withCompression(compressAlgo).withIncludesMvcc(false).withIncludesTags(useTags).withHBaseCheckSum(true).build();
        HFileBlock.FSReaderV2 blockReader = new HFileBlock.FSReaderV2(fsdis, fileSize, meta);
        KeyValue.KVComparator comparator = trailer.createComparator();
        HFileBlockIndex.BlockIndexReader dataBlockIndexReader = new HFileBlockIndex.BlockIndexReader(comparator, trailer.getNumDataIndexLevels());
        HFileBlockIndex.BlockIndexReader metaBlockIndexReader = new HFileBlockIndex.BlockIndexReader(KeyValue.RAW_COMPARATOR, 1);
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        if (findMidKey) {
            byte[] midkey = dataBlockIndexReader.midkey();
            Assert.assertNotNull((String)"Midkey should not be null", (Object)midkey);
        }
        metaBlockIndexReader.readRootIndex(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX).getByteStream(), trailer.getMetaIndexCount());
        HFile.FileInfo fileInfo = new HFile.FileInfo();
        fileInfo.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        byte[] keyValueFormatVersion = fileInfo.get(HFileWriterV3.KEY_VALUE_VERSION);
        boolean includeMemstoreTS = keyValueFormatVersion != null && Bytes.toInt(keyValueFormatVersion) > 0;
        int entriesRead = 0;
        int blocksRead = 0;
        long memstoreTS = 0L;
        fsdis.seek(0L);
        for (curBlockPos = 0L; curBlockPos <= trailer.getLastDataBlockOffset(); curBlockPos += (long)block.getOnDiskSizeWithHeader()) {
            block = blockReader.readBlockData(curBlockPos, -1L, -1, false);
            Assert.assertEquals((Object)((Object)BlockType.DATA), (Object)((Object)block.getBlockType()));
            ByteBuffer buf = block.getBufferWithoutHeader();
            int keyLen = -1;
            while (buf.hasRemaining()) {
                keyLen = buf.getInt();
                int valueLen = buf.getInt();
                byte[] key = new byte[keyLen];
                buf.get(key);
                byte[] value = new byte[valueLen];
                buf.get(value);
                byte[] tagValue = null;
                if (useTags) {
                    short tagLen = buf.getShort();
                    tagValue = new byte[tagLen];
                    buf.get(tagValue);
                }
                if (includeMemstoreTS) {
                    ByteArrayInputStream byte_input = new ByteArrayInputStream(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                    DataInputStream data_input = new DataInputStream(byte_input);
                    memstoreTS = WritableUtils.readVLong(data_input);
                    buf.position(buf.position() + WritableUtils.getVIntSize(memstoreTS));
                }
                Assert.assertTrue((Bytes.compareTo(key, ((KeyValue)keyValues.get(entriesRead)).getKey()) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((Bytes.compareTo(value, ((KeyValue)keyValues.get(entriesRead)).getValue()) == 0 ? 1 : 0) != 0);
                if (useTags) {
                    Assert.assertNotNull((Object)tagValue);
                    KeyValue tkv = (KeyValue)keyValues.get(entriesRead);
                    Assert.assertEquals((long)tagValue.length, (long)tkv.getTagsLength());
                    Assert.assertTrue((Bytes.compareTo(tagValue, 0, tagValue.length, tkv.getBuffer(), tkv.getTagsOffset(), tkv.getTagsLength()) == 0 ? 1 : 0) != 0);
                }
                ++entriesRead;
            }
            ++blocksRead;
        }
        LOG.info("Finished reading: entries=" + entriesRead + ", blocksRead=" + blocksRead);
        Assert.assertEquals((long)entryCount, (long)entriesRead);
        int metaCounter = 0;
        while (fsdis.getPos() < trailer.getLoadOnOpenDataOffset()) {
            LOG.info("Current offset: " + fsdis.getPos() + ", scanning until " + trailer.getLoadOnOpenDataOffset());
            HFileBlock block2 = blockReader.readBlockData(curBlockPos, -1L, -1, false);
            Assert.assertEquals((Object)((Object)BlockType.META), (Object)((Object)block2.getBlockType()));
            Text t = new Text();
            ByteBuffer buf = block2.getBufferWithoutHeader();
            if (Writables.getWritable(buf.array(), buf.arrayOffset(), buf.limit(), t) == null) {
                throw new IOException("Failed to deserialize block " + this + " into a " + t.getClass().getSimpleName());
            }
            Text expectedText = metaCounter == 0 ? new Text("Paris") : (metaCounter == 1 ? new Text("Moscow") : new Text("Washington, D.C."));
            Assert.assertEquals((Object)expectedText, (Object)t);
            LOG.info("Read meta block data: " + t);
            ++metaCounter;
            curBlockPos += (long)block2.getOnDiskSizeWithHeader();
        }
        fsdis.close();
    }
}

