/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocatorException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBucketCache {
    static final Log LOG = LogFactory.getLog(TestBucketCache.class);
    BucketCache cache;
    final int CACHE_SIZE = 1000000;
    final int NUM_BLOCKS = 100;
    final int BLOCK_SIZE = 10000;
    final int NUM_THREADS = 1000;
    final int NUM_QUERIES = 10000;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;
    String ioEngineName = "heap";
    String persistencePath = null;

    @Before
    public void setup() throws FileNotFoundException, IOException {
        this.cache = new MockedBucketCache(this.ioEngineName, 0x2000000L, 3, 64, this.persistencePath);
    }

    @After
    public void tearDown() {
        this.cache.shutdown();
    }

    @Test
    public void testBucketAllocator() throws BucketAllocatorException {
        BucketAllocator mAllocator = this.cache.getAllocator();
        int[] blockSizes = new int[]{4096, 8192};
        boolean full = false;
        int i = 0;
        ArrayList<Long> allocations = new ArrayList<Long>();
        while (!full) {
            try {
                allocations.add(new Long(mAllocator.allocateBlock(blockSizes[i % blockSizes.length])));
                ++i;
            }
            catch (CacheFullException cfe) {
                full = true;
            }
        }
        for (i = 0; i < blockSizes.length; ++i) {
            BucketAllocator.BucketSizeInfo bucketSizeInfo = mAllocator.roundUpToBucketSizeInfo(blockSizes[0]);
            BucketAllocator.IndexStatistics indexStatistics = bucketSizeInfo.statistics();
            Assert.assertTrue((indexStatistics.freeCount() == 0L ? 1 : 0) != 0);
        }
        Iterator i$ = allocations.iterator();
        while (i$.hasNext()) {
            long offset = (Long)i$.next();
            Assert.assertTrue((mAllocator.sizeOfAllocation(offset) == mAllocator.freeBlock(offset) ? 1 : 0) != 0);
        }
        Assert.assertTrue((mAllocator.getUsedSize() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCacheSimple() throws Exception {
        CacheTestUtils.testCacheSimple(this.cache, 10000, 10000);
    }

    @Test
    public void testCacheMultiThreadedSingleKey() throws Exception {
        CacheTestUtils.hammerSingleKey(this.cache, 10000, 1000, 10000);
    }

    @Test
    public void testHeapSizeChanges() throws Exception {
        this.cache.stopWriterThreads();
        CacheTestUtils.testHeapSizeChanges(this.cache, 10000);
    }

    private class MockedBucketCache
    extends BucketCache {
        public MockedBucketCache(String ioEngineName, long capacity, int writerThreads, int writerQLen, String persistencePath) throws FileNotFoundException, IOException {
            super(ioEngineName, capacity, 8192, writerThreads, writerQLen, persistencePath);
            this.wait_when_cache = true;
        }

        @Override
        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
            if (super.getBlock(cacheKey, true, false) != null) {
                throw new RuntimeException("Cached an already cached block");
            }
            super.cacheBlock(cacheKey, buf, inMemory);
        }

        @Override
        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
            if (super.getBlock(cacheKey, true, false) != null) {
                throw new RuntimeException("Cached an already cached block");
            }
            super.cacheBlock(cacheKey, buf);
        }
    }
}

