/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFileIOEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIOEngine() throws IOException {
        int size = 0x200000;
        String filePath = "testFileIOEngine";
        try {
            FileIOEngine fileIOEngine = new FileIOEngine(filePath, size);
            for (int i = 0; i < 50; ++i) {
                int len = (int)Math.floor(Math.random() * 100.0);
                long offset = (long)Math.floor(Math.random() * (double)size % (double)(size - len));
                byte[] data1 = new byte[len];
                for (int j = 0; j < data1.length; ++j) {
                    data1[j] = (byte)(Math.random() * 255.0);
                }
                byte[] data2 = new byte[len];
                fileIOEngine.write(ByteBuffer.wrap(data1), offset);
                fileIOEngine.read(ByteBuffer.wrap(data2), offset);
                for (int j = 0; j < data1.length; ++j) {
                    Assert.assertTrue((data1[j] == data2[j] ? 1 : 0) != 0);
                }
            }
        }
        finally {
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

