/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.slab.SingleSizeCache;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSingleSizeCache {
    SingleSizeCache cache;
    final int CACHE_SIZE = 1000000;
    final int NUM_BLOCKS = 100;
    final int BLOCK_SIZE = 10000;
    final int NUM_THREADS = 100;
    final int NUM_QUERIES = 10000;

    @Before
    public void setup() {
        this.cache = new SingleSizeCache(10000, 100, null);
    }

    @After
    public void tearDown() {
        this.cache.shutdown();
    }

    @Test
    public void testCacheSimple() throws Exception {
        CacheTestUtils.testCacheSimple(this.cache, 10000, 10000);
    }

    @Test
    public void testCacheMultiThreaded() throws Exception {
        CacheTestUtils.testCacheMultiThreaded(this.cache, 10000, 100, 10000, 0.8);
    }

    @Test
    public void testCacheMultiThreadedSingleKey() throws Exception {
        CacheTestUtils.hammerSingleKey(this.cache, 10000, 100, 10000);
    }

    @Test
    public void testCacheMultiThreadedEviction() throws Exception {
        CacheTestUtils.hammerEviction(this.cache, 10000, 100, 10000);
    }

    @Test
    public void testHeapSizeChanges() {
        CacheTestUtils.testHeapSizeChanges(this.cache, 10000);
    }
}

