/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.slab.SlabCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSlabCache {
    static final int CACHE_SIZE = 1000000;
    static final int NUM_BLOCKS = 101;
    static final int BLOCK_SIZE = 9900;
    static final int NUM_THREADS = 50;
    static final int NUM_QUERIES = 10000;
    SlabCache cache;

    @Before
    public void setup() {
        this.cache = new SlabCache(1019800L, 9900L);
        this.cache.addSlabByConf(new Configuration());
    }

    @After
    public void tearDown() {
        this.cache.shutdown();
    }

    @Test
    public void testElementPlacement() {
        Assert.assertEquals((long)this.cache.getHigherBlock(9900).getKey().intValue(), (long)10890L);
        Assert.assertEquals((long)this.cache.getHigherBlock(19800).getKey().intValue(), (long)20790L);
    }

    @Test
    public void testCacheSimple() throws Exception {
        CacheTestUtils.testCacheSimple(this.cache, 9900, 10000);
    }

    @Test
    public void testCacheMultiThreaded() throws Exception {
        CacheTestUtils.testCacheMultiThreaded(this.cache, 9900, 50, 10000, 0.8);
    }

    @Test
    public void testCacheMultiThreadedSingleKey() throws Exception {
        CacheTestUtils.hammerSingleKey(this.cache, 9900, 50, 10000);
    }

    @Test
    public void testCacheMultiThreadedEviction() throws Exception {
        CacheTestUtils.hammerEviction(this.cache, 9900, 10, 10000);
    }

    @Test
    public void testStatsArithmetic() {
        SlabCache.SlabStats test = this.cache.requestStats;
        for (int i = 0; i < test.NUMDIVISIONS; ++i) {
            Assert.assertTrue((String)("Upper for index " + i + " is " + test.getUpperBound(i) + " lower " + test.getLowerBound(i + 1)), (test.getUpperBound(i) <= test.getLowerBound(i + 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHeapSizeChanges() {
        CacheTestUtils.testHeapSizeChanges(this.cache, 9900);
    }
}

