/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;

@InterfaceAudience.Private
public abstract class CoprocessorRpcChannel
implements RpcChannel,
BlockingRpcChannel {
    private static Log LOG = LogFactory.getLog(CoprocessorRpcChannel.class);

    @Override
    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> callback) {
        Message response = null;
        try {
            response = this.callExecService(method, request, responsePrototype);
        }
        catch (IOException ioe) {
            LOG.warn("Call failed on IOException", ioe);
            ResponseConverter.setControllerException(controller, ioe);
        }
        if (callback != null) {
            callback.run(response);
        }
    }

    @Override
    public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
        try {
            return this.callExecService(method, request, responsePrototype);
        }
        catch (IOException ioe) {
            throw new ServiceException("Error calling method " + method.getFullName(), ioe);
        }
    }

    protected abstract Message callExecService(Descriptors.MethodDescriptor var1, Message var2, Message var3) throws IOException;
}

