/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.ipc.RpcServer;

public class MetricsHBaseServerWrapperImpl
implements MetricsHBaseServerWrapper {
    private RpcServer server;

    MetricsHBaseServerWrapperImpl(RpcServer server) {
        this.server = server;
    }

    @Override
    public long getTotalQueueSize() {
        if (this.server == null) {
            return 0L;
        }
        return this.server.callQueueSize.get();
    }

    @Override
    public int getGeneralQueueLength() {
        if (this.server == null || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getGeneralQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        if (this.server == null || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReplicationQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        if (this.server == null || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getPriorityQueueLength();
    }

    @Override
    public int getNumOpenConnections() {
        if (this.server == null || this.server.connectionList == null) {
            return 0;
        }
        return this.server.connectionList.size();
    }
}

