/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class HRegionPartitioner<K2, V2>
implements Partitioner<ImmutableBytesWritable, V2> {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    private HTable table;
    private byte[][] startKeys;

    @Override
    public void configure(JobConf job) {
        try {
            this.table = new HTable(HBaseConfiguration.create(job), job.get("hbase.mapred.outputtable"));
        }
        catch (IOException e) {
            this.LOG.error(e);
        }
        try {
            this.startKeys = this.table.getStartKeys();
        }
        catch (IOException e) {
            this.LOG.error(e);
        }
    }

    @Override
    public int getPartition(ImmutableBytesWritable key, V2 value, int numPartitions) {
        byte[] region = null;
        if (this.startKeys.length == 1) {
            return 0;
        }
        try {
            region = this.table.getRegionLocation(key.get()).getRegionInfo().getStartKey();
        }
        catch (IOException e) {
            this.LOG.error(e);
        }
        for (int i = 0; i < this.startKeys.length; ++i) {
            if (Bytes.compareTo(region, this.startKeys[i]) != 0) continue;
            if (i >= numPartitions - 1) {
                return (Integer.toString(i).hashCode() & Integer.MAX_VALUE) % numPartitions;
            }
            return i;
        }
        return 0;
    }
}

