/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, Put> {
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";
    private final Log LOG = LogFactory.getLog(TableOutputFormat.class);

    @Override
    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        String tableName = job.get(OUTPUT_TABLE);
        HTable table = null;
        try {
            table = new HTable(HBaseConfiguration.create(job), tableName);
        }
        catch (IOException e) {
            this.LOG.error(e);
            throw e;
        }
        table.setAutoFlush(false, true);
        return new TableRecordWriter(table);
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        String tableName = job.get(OUTPUT_TABLE);
        if (tableName == null) {
            throw new IOException("Must specify table name");
        }
    }

    protected static class TableRecordWriter
    implements RecordWriter<ImmutableBytesWritable, Put> {
        private HTable m_table;

        public TableRecordWriter(HTable table) {
            this.m_table = table;
        }

        @Override
        public void close(Reporter reporter) throws IOException {
            this.m_table.close();
        }

        @Override
        public void write(ImmutableBytesWritable key, Put value) throws IOException {
            this.m_table.put(new Put(value));
        }
    }
}

