/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSplitTable {
    @Test
    public void testSplitTableCompareTo() {
        TableSplit aTableSplit = new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA");
        TableSplit bTableSplit = new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("iii"), Bytes.toBytes("kkk"), "locationA");
        TableSplit cTableSplit = new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("lll"), Bytes.toBytes("zzz"), "locationA");
        Assert.assertTrue((aTableSplit.compareTo(aTableSplit) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((bTableSplit.compareTo(bTableSplit) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((cTableSplit.compareTo(cTableSplit) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((aTableSplit.compareTo(bTableSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((bTableSplit.compareTo(aTableSplit) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((aTableSplit.compareTo(cTableSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((cTableSplit.compareTo(aTableSplit) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((bTableSplit.compareTo(cTableSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((cTableSplit.compareTo(bTableSplit) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cTableSplit.compareTo(aTableSplit) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitTableEquals() {
        Assert.assertFalse((boolean)new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA").equals(new TableSplit(Bytes.toBytes("tableB"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA")));
        Assert.assertFalse((boolean)new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA").equals(new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("bbb"), Bytes.toBytes("ddd"), "locationA")));
        Assert.assertFalse((boolean)new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA").equals(new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("eee"), "locationA")));
        Assert.assertFalse((boolean)new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA").equals(new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationB")));
        Assert.assertTrue((boolean)new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA").equals(new TableSplit(Bytes.toBytes("tableA"), Bytes.toBytes("aaa"), Bytes.toBytes("ddd"), "locationA")));
    }
}

