/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CopyTable
extends Configured
implements Tool {
    static final String NAME = "copytable";
    static long startTime = 0L;
    static long endTime = 0L;
    static int versions = -1;
    static String tableName = null;
    static String startRow = null;
    static String stopRow = null;
    static String newTableName = null;
    static String peerAddress = null;
    static String families = null;
    static boolean allCells = false;

    public CopyTable(Configuration conf) {
        super(conf);
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!CopyTable.doCommandLine(args)) {
            return null;
        }
        Job job = new Job(conf, "copytable_" + tableName);
        job.setJarByClass(CopyTable.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        if (startTime != 0L) {
            scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        }
        if (allCells) {
            scan.setRaw(true);
        }
        if (versions >= 0) {
            scan.setMaxVersions(versions);
        }
        if (startRow != null) {
            scan.setStartRow(Bytes.toBytes(startRow));
        }
        if (stopRow != null) {
            scan.setStopRow(Bytes.toBytes(stopRow));
        }
        if (families != null) {
            String[] fams = families.split(",");
            HashMap<String, String> cfRenameMap = new HashMap<String, String>();
            for (String fam : fams) {
                String sourceCf;
                if (fam.contains(":")) {
                    String[] srcAndDest = fam.split(":", 2);
                    sourceCf = srcAndDest[0];
                    String destCf = srcAndDest[1];
                    cfRenameMap.put(sourceCf, destCf);
                } else {
                    sourceCf = fam;
                }
                scan.addFamily(Bytes.toBytes(sourceCf));
            }
            Import.configureCfRenaming(job.getConfiguration(), cfRenameMap);
        }
        TableMapReduceUtil.initTableMapperJob(tableName, scan, Import.Importer.class, null, null, job);
        TableMapReduceUtil.initTableReducerJob(newTableName == null ? tableName : newTableName, null, job, null, peerAddress, null, null);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: CopyTable [general options] [--starttime=X] [--endtime=Y] [--new.name=NEW] [--peer.adr=ADR] <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" rs.class     hbase.regionserver.class of the peer cluster");
        System.err.println("              specify if different from current cluster");
        System.err.println(" rs.impl      hbase.regionserver.impl of the peer cluster");
        System.err.println(" startrow     the start row");
        System.err.println(" stoprow      the stop row");
        System.err.println(" starttime    beginning of the time range (unixtime in millis)");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" endtime      end of the time range.  Ignored if no starttime specified.");
        System.err.println(" versions     number of cell versions to copy");
        System.err.println(" new.name     new table's name");
        System.err.println(" peer.adr     Address of the peer cluster given in the format");
        System.err.println("              hbase.zookeeer.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        System.err.println(" families     comma-separated list of families to copy");
        System.err.println("              To copy from cf1 to cf2, give sourceCfName:destCfName. ");
        System.err.println("              To keep the same name, just give \"cfName\"");
        System.err.println(" all.cells    also copy delete markers and deleted cells");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" tablename    Name of the table to copy");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To copy 'TestTable' to a cluster that uses replication for a 1 hour window:");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.mapreduce.CopyTable --starttime=1265875194289 --endtime=1265878794289 --peer.adr=server1,server2,server3:2181:/hbase --families=myOldCf:myNewCf,cf2,cf3 TestTable ");
        System.err.println("For performance consider the following general options:\n-Dhbase.client.scanner.caching=100\n-Dmapred.map.tasks.speculative.execution=false");
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            CopyTable.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    CopyTable.printUsage(null);
                    return false;
                }
                String startRowArgKey = "--startrow=";
                if (cmd.startsWith("--startrow=")) {
                    startRow = cmd.substring("--startrow=".length());
                    continue;
                }
                String stopRowArgKey = "--stoprow=";
                if (cmd.startsWith("--stoprow=")) {
                    stopRow = cmd.substring("--stoprow=".length());
                    continue;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String versionsArgKey = "--versions=";
                if (cmd.startsWith("--versions=")) {
                    versions = Integer.parseInt(cmd.substring("--versions=".length()));
                    continue;
                }
                String newNameArgKey = "--new.name=";
                if (cmd.startsWith("--new.name=")) {
                    newTableName = cmd.substring("--new.name=".length());
                    continue;
                }
                String peerAdrArgKey = "--peer.adr=";
                if (cmd.startsWith("--peer.adr=")) {
                    peerAddress = cmd.substring("--peer.adr=".length());
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    families = cmd.substring("--families=".length());
                    continue;
                }
                if (cmd.startsWith("--all.cells")) {
                    allCells = true;
                    continue;
                }
                if (i == args.length - 1) {
                    tableName = cmd;
                    continue;
                }
                CopyTable.printUsage("Invalid argument '" + cmd + "'");
                return false;
            }
            if (newTableName == null && peerAddress == null) {
                CopyTable.printUsage("At least a new table name or a peer address must be specified");
                return false;
            }
            if (startTime > endTime) {
                CopyTable.printUsage("Invalid time range filter: starttime=" + startTime + " >  endtime=" + endTime);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CopyTable.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run(new CopyTable(HBaseConfiguration.create()), args);
        System.exit(ret);
    }

    @Override
    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        Job job = CopyTable.createSubmittableJob(this.getConf(), otherArgs);
        if (job == null) {
            return 1;
        }
        return job.waitForCompletion(true) ? 0 : 1;
    }
}

