/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GroupingTableMapper
extends TableMapper<ImmutableBytesWritable, Result>
implements Configurable {
    public static final String GROUP_COLUMNS = "hbase.mapred.groupingtablemap.columns";
    protected byte[][] columns;
    private Configuration conf = null;

    public static void initJob(String table, Scan scan, String groupColumns, Class<? extends TableMapper> mapper, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, ImmutableBytesWritable.class, Result.class, job);
        job.getConfiguration().set(GROUP_COLUMNS, groupColumns);
    }

    @Override
    public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[][] keyVals = this.extractKeyValues(value);
        if (keyVals != null) {
            ImmutableBytesWritable tKey = this.createGroupKey(keyVals);
            context.write(tKey, value);
        }
    }

    protected byte[][] extractKeyValues(Result r) {
        byte[][] keyVals = null;
        ArrayList<byte[]> foundList = new ArrayList<byte[]>();
        int numCols = this.columns.length;
        if (numCols > 0) {
            block0: for (Cell value : r.listCells()) {
                byte[] column = KeyValue.makeColumn(CellUtil.cloneFamily(value), CellUtil.cloneQualifier(value));
                for (int i = 0; i < numCols; ++i) {
                    if (!Bytes.equals(column, this.columns[i])) continue;
                    foundList.add(CellUtil.cloneValue(value));
                    continue block0;
                }
            }
            if (foundList.size() == numCols) {
                keyVals = (byte[][])foundList.toArray((T[])new byte[numCols][]);
            }
        }
        return keyVals;
    }

    protected ImmutableBytesWritable createGroupKey(byte[][] vals) {
        if (vals == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(Bytes.toString(vals[i]));
        }
        return new ImmutableBytesWritable(Bytes.toBytes(sb.toString()));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration configuration) {
        this.conf = configuration;
        String[] cols = this.conf.get(GROUP_COLUMNS, "").split(" ");
        this.columns = new byte[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            this.columns[i] = Bytes.toBytes(cols[i]);
        }
    }
}

