/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.CellCounter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCellCounter {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes("row1");
    private static final byte[] ROW2 = Bytes.toBytes("row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes("a");
    private static final byte[] FAMILY_B = Bytes.toBytes("b");
    private static final byte[] QUALIFIER = Bytes.toBytes("q");
    private static Path FQ_OUTPUT_DIR;
    private static final String OUTPUT_DIR;
    private static long now;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        UTIL.startMiniMapReduceCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified(new LocalFileSystem());
        FileUtil.fullyDelete(new File(OUTPUT_DIR));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounter() throws Exception {
        String sourceTable = "sourceTable";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = UTIL.createTable(Bytes.toBytes(sourceTable), (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.add(FAMILY_A, QUALIFIER, now, Bytes.toBytes("Data11"));
            p.add(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes("Data12"));
            p.add(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes("Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILY_B, QUALIFIER, now, Bytes.toBytes("Dat21"));
            p.add(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes("Data22"));
            p.add(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes("Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable, FQ_OUTPUT_DIR.toString(), ";", "^row1"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString(inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            t.close();
        }
    }

    private boolean runCount(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration configuration = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = CellCounter.createSubmittableJob(configuration, args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCellCounterMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                CellCounter.main(args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage:"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    static {
        OUTPUT_DIR = "target" + File.separator + "test-data" + File.separator + "output";
        now = System.currentTimeMillis();
    }
}

