/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class TestTableInputFormatScanBase {
    static final Log LOG = LogFactory.getLog(TestTableInputFormatScanBase.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final byte[] TABLE_NAME = Bytes.toBytes("scantest");
    static final byte[] INPUT_FAMILY = Bytes.toBytes("contents");
    static final String KEY_STARTROW = "startRow";
    static final String KEY_LASTROW = "stpRow";
    private static HTable table = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        TEST_UTIL.enableDebug(TableInputFormat.class);
        TEST_UTIL.enableDebug(TableInputFormatBase.class);
        TEST_UTIL.startMiniCluster(3);
        table = TEST_UTIL.createTable(TABLE_NAME, INPUT_FAMILY);
        TEST_UTIL.createMultiRegions(table, INPUT_FAMILY);
        TEST_UTIL.loadTable(table, INPUT_FAMILY, false);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    protected void testScanFromConfiguration(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "ScanFromConfig" + (start != null ? start.toUpperCase() : "Empty") + "To" + (stop != null ? stop.toUpperCase() : "Empty");
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.set("hbase.mapreduce.inputtable", Bytes.toString(TABLE_NAME));
        c.set("hbase.mapreduce.scan.column.family", Bytes.toString(INPUT_FAMILY));
        c.set(KEY_STARTROW, start != null ? start : "");
        c.set(KEY_LASTROW, last != null ? last : "");
        if (start != null) {
            c.set("hbase.mapreduce.scan.row.start", start);
        }
        if (stop != null) {
            c.set("hbase.mapreduce.scan.row.stop", stop);
        }
        Job job = new Job(c, jobName);
        job.setMapperClass(ScanMapper.class);
        job.setReducerClass(ScanReducer.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(ImmutableBytesWritable.class);
        job.setInputFormatClass(TableInputFormat.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath(job, new Path(job.getJobName()));
        TableMapReduceUtil.addDependencyJars(job);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    protected void testScan(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "Scan" + (start != null ? start.toUpperCase() : "Empty") + "To" + (stop != null ? stop.toUpperCase() : "Empty");
        LOG.info("Before map/reduce startup - job " + jobName);
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILY);
        if (start != null) {
            scan.setStartRow(Bytes.toBytes(start));
        }
        c.set(KEY_STARTROW, start != null ? start : "");
        if (stop != null) {
            scan.setStopRow(Bytes.toBytes(stop));
        }
        c.set(KEY_LASTROW, last != null ? last : "");
        LOG.info("scan before: " + scan);
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(TABLE_NAME), scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath(job, new Path(job.getJobName()));
        LOG.info("Started " + job.getJobName());
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        LOG.info("After map/reduce completion - job " + jobName);
    }

    public static class ScanReducer
    extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private String first = null;
        private String last = null;

        @Override
        protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (ImmutableBytesWritable value : values) {
                String val = Bytes.toStringBinary(value.get());
                LOG.info("reduce: key[" + count + "] -> " + Bytes.toStringBinary(key.get()) + ", value -> " + val);
                if (this.first == null) {
                    this.first = val;
                }
                this.last = val;
                ++count;
            }
        }

        @Override
        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration c = context.getConfiguration();
            String startRow = c.get(TestTableInputFormatScanBase.KEY_STARTROW);
            String lastRow = c.get(TestTableInputFormatScanBase.KEY_LASTROW);
            LOG.info("cleanup: first -> \"" + this.first + "\", start row -> \"" + startRow + "\"");
            LOG.info("cleanup: last -> \"" + this.last + "\", last row -> \"" + lastRow + "\"");
            if (startRow != null && startRow.length() > 0) {
                Assert.assertEquals((Object)startRow, (Object)this.first);
            }
            if (lastRow != null && lastRow.length() > 0) {
                Assert.assertEquals((Object)lastRow, (Object)this.last);
            }
        }
    }

    public static class ScanMapper
    extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
        @Override
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString(INPUT_FAMILY) + "'.");
            }
            String val = Bytes.toStringBinary(value.getValue(INPUT_FAMILY, null));
            LOG.info("map: key -> " + Bytes.toStringBinary(key.get()) + ", value -> " + val);
            context.write(key, key);
        }
    }
}

