/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IdentityTableReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TestTableMapReduceBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableMapReduce
extends TestTableMapReduceBase {
    private static final Log LOG = LogFactory.getLog(TestTableMapReduce.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    protected void runTestOnTable(HTable table) throws IOException {
        Job job = null;
        try {
            LOG.info("Before map/reduce startup");
            job = new Job(table.getConfiguration(), "process column contents");
            job.setNumReduceTasks(1);
            Scan scan = new Scan();
            scan.addFamily(INPUT_FAMILY);
            TableMapReduceUtil.initTableMapperJob(Bytes.toString(table.getTableName()), scan, ProcessContentsMapper.class, ImmutableBytesWritable.class, Put.class, job);
            TableMapReduceUtil.initTableReducerJob(Bytes.toString(table.getTableName()), IdentityTableReducer.class, job);
            FileOutputFormat.setOutputPath(job, new Path("test"));
            LOG.info("Started " + Bytes.toString(table.getTableName()));
            Assert.assertTrue((boolean)job.waitForCompletion(true));
            LOG.info("After map/reduce completion");
            this.verify(Bytes.toString(table.getTableName()));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            table.close();
            if (job != null) {
                FileUtil.fullyDelete(new File(job.getConfiguration().get("hadoop.tmp.dir")));
            }
        }
    }

    static class ProcessContentsMapper
    extends TableMapper<ImmutableBytesWritable, Put> {
        ProcessContentsMapper() {
        }

        @Override
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> cf = value.getMap();
            if (!cf.containsKey(TestTableMapReduceBase.INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString(TestTableMapReduceBase.INPUT_FAMILY) + "'.");
            }
            String originalValue = Bytes.toString(value.getValue(TestTableMapReduceBase.INPUT_FAMILY, null));
            StringBuilder newValue = new StringBuilder(originalValue);
            newValue.reverse();
            Put outval = new Put(key.get());
            outval.add(TestTableMapReduceBase.OUTPUT_FAMILY, null, Bytes.toBytes(newValue.toString()));
            context.write(key, outval);
        }
    }
}

