/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.hadoopbackport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.JarFinder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestJarFinder {
    @Test
    public void testJar() throws Exception {
        String jar = JarFinder.getJar(LogFactory.class);
        Assert.assertTrue((boolean)new File(jar).exists());
    }

    private static void delete(File file) throws IOException {
        if (file.getAbsolutePath().length() < 5) {
            throw new IllegalArgumentException(MessageFormat.format("Path [{0}] is too short, not deleting", file.getAbsolutePath()));
        }
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    TestJarFinder.delete(child);
                }
            }
            if (!file.delete()) {
                throw new RuntimeException(MessageFormat.format("Could not delete path [{0}]", file.getAbsolutePath()));
            }
        }
    }

    @Test
    public void testExpandedClasspath() throws Exception {
        String jar = JarFinder.getJar(TestJarFinder.class);
        Assert.assertTrue((boolean)new File(jar).exists());
    }

    @Test
    public void testExistingManifest() throws Exception {
        File dir = new File(System.getProperty("test.build.dir", "target/test-dir"), TestJarFinder.class.getName() + "-testExistingManifest");
        TestJarFinder.delete(dir);
        dir.mkdirs();
        File metaInfDir = new File(dir, "META-INF");
        metaInfDir.mkdirs();
        File manifestFile = new File(metaInfDir, "MANIFEST.MF");
        Manifest manifest = new Manifest();
        FileOutputStream os = new FileOutputStream(manifestFile);
        manifest.write(os);
        ((OutputStream)os).close();
        File propsFile = new File(dir, "props.properties");
        FileWriter writer = new FileWriter(propsFile);
        new Properties().store(writer, "");
        ((Writer)writer).close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream zos = new JarOutputStream(baos);
        JarFinder.jarDir(dir, "", zos);
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNotNull((Object)jis.getManifest());
        jis.close();
    }

    @Test
    public void testNoManifest() throws Exception {
        File dir = new File(System.getProperty("test.build.dir", "target/test-dir"), TestJarFinder.class.getName() + "-testNoManifest");
        TestJarFinder.delete(dir);
        dir.mkdirs();
        File propsFile = new File(dir, "props.properties");
        FileWriter writer = new FileWriter(propsFile);
        new Properties().store(writer, "");
        ((Writer)writer).close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream zos = new JarOutputStream(baos);
        JarFinder.jarDir(dir, "", zos);
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNotNull((Object)jis.getManifest());
        jis.close();
    }
}

