/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ActiveMasterManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ActiveMasterManager.class);
    final AtomicBoolean clusterHasActiveMaster = new AtomicBoolean(false);
    final AtomicBoolean clusterShutDown = new AtomicBoolean(false);
    private final ServerName sn;
    private final Server master;

    ActiveMasterManager(ZooKeeperWatcher watcher, ServerName sn, Server master) {
        super(watcher);
        this.sn = sn;
        this.master = master;
    }

    @Override
    public void nodeCreated(String path) {
        this.handle(path);
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.equals(this.watcher.clusterStateZNode) && !this.master.isStopped()) {
            this.clusterShutDown.set(true);
        }
        this.handle(path);
    }

    void handle(String path) {
        if (path.equals(this.watcher.getMasterAddressZNode()) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterNodeChange() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.watcher.getMasterAddressZNode())) {
                    LOG.debug("A master is now available");
                    this.clusterHasActiveMaster.set(true);
                } else {
                    LOG.debug("No master available. Notifying waiting threads");
                    this.clusterHasActiveMaster.set(false);
                    this.clusterHasActiveMaster.notifyAll();
                }
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean blockUntilBecomingActiveMaster(MonitoredTask startupStatus) {
        while (true) {
            startupStatus.setStatus("Trying to register in ZK as active master");
            try {
                String msg;
                String backupZNode = ZKUtil.joinZNode(this.watcher.backupMasterAddressesZNode, this.sn.toString());
                if (MasterAddressTracker.setMasterAddress(this.watcher, this.watcher.getMasterAddressZNode(), this.sn)) {
                    if (ZKUtil.checkExists(this.watcher, backupZNode) != -1) {
                        LOG.info("Deleting ZNode for " + backupZNode + " from backup master directory");
                        ZKUtil.deleteNodeFailSilent(this.watcher, backupZNode);
                    }
                    ZNodeClearer.writeMyEphemeralNodeOnDisk(this.sn.toString());
                    startupStatus.setStatus("Successfully registered as active master.");
                    this.clusterHasActiveMaster.set(true);
                    LOG.info("Registered Active Master=" + this.sn);
                    return true;
                }
                this.clusterHasActiveMaster.set(true);
                LOG.info("Adding ZNode for " + backupZNode + " in backup master directory");
                MasterAddressTracker.setMasterAddress(this.watcher, backupZNode, this.sn);
                byte[] bytes = ZKUtil.getDataAndWatch(this.watcher, this.watcher.getMasterAddressZNode());
                if (bytes == null) {
                    msg = "A master was detected, but went down before its address could be read.  Attempting to become the next active master";
                } else {
                    ServerName currentMaster;
                    try {
                        currentMaster = ServerName.parseFrom(bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn("Failed parse", e);
                        continue;
                    }
                    if (ServerName.isSameHostnameAndPort(currentMaster, this.sn)) {
                        msg = "Current master has this master's address, " + currentMaster + "; master was restarted? Deleting node.";
                        ZKUtil.deleteNode(this.watcher, this.watcher.getMasterAddressZNode());
                        ZNodeClearer.deleteMyEphemeralNodeOnDisk();
                    } else {
                        msg = "Another master is the active master, " + currentMaster + "; waiting to become the next active master";
                    }
                }
                LOG.info(msg);
                startupStatus.setStatus(msg);
            }
            catch (KeeperException ke) {
                this.master.abort("Received an unexpected KeeperException, aborting", ke);
                return false;
            }
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                    try {
                        this.clusterHasActiveMaster.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Interrupted waiting for master to die", e);
                    }
                }
                if (this.clusterShutDown.get()) {
                    this.master.stop("Cluster went down before this master became active");
                }
                if (this.master.isStopped()) {
                    return false;
                }
            }
        }
    }

    public boolean isActiveMaster() {
        try {
            if (ZKUtil.checkExists(this.watcher, this.watcher.getMasterAddressZNode()) >= 0) {
                return true;
            }
        }
        catch (KeeperException ke) {
            LOG.info("Received an unexpected KeeperException when checking isActiveMaster : " + ke);
        }
        return false;
    }

    public void stop() {
        try {
            ServerName activeMaster = null;
            try {
                activeMaster = MasterAddressTracker.getMasterAddress(this.watcher);
            }
            catch (IOException e) {
                LOG.warn("Failed get of master address: " + e.toString());
            }
            if (activeMaster != null && activeMaster.equals(this.sn)) {
                ZKUtil.deleteNode(this.watcher, this.watcher.getMasterAddressZNode());
                ZNodeClearer.deleteMyEphemeralNodeOnDisk();
            }
        }
        catch (KeeperException e) {
            LOG.error(this.watcher.prefix("Error deleting our own master address node"), e);
        }
    }
}

