/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionStates;

@InterfaceAudience.Private
public class BulkReOpen
extends BulkAssigner {
    private final Map<ServerName, List<HRegionInfo>> rsToRegions;
    private final AssignmentManager assignmentManager;
    private static final Log LOG = LogFactory.getLog(BulkReOpen.class);

    public BulkReOpen(Server server, Map<ServerName, List<HRegionInfo>> serverToRegions, AssignmentManager am) {
        super(server);
        this.assignmentManager = am;
        this.rsToRegions = serverToRegions;
    }

    @Override
    protected void populatePool(ExecutorService pool) {
        LOG.debug("Creating threads for each region server ");
        for (Map.Entry<ServerName, List<HRegionInfo>> e : this.rsToRegions.entrySet()) {
            final List<HRegionInfo> hris = e.getValue();
            HashMap<String, RegionPlan> plans = new HashMap<String, RegionPlan>();
            for (HRegionInfo hri : hris) {
                RegionPlan reOpenPlan = this.assignmentManager.getRegionReopenPlan(hri);
                plans.put(hri.getEncodedName(), reOpenPlan);
            }
            this.assignmentManager.addPlans(plans);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BulkReOpen.this.unassign(hris);
                    }
                    catch (Throwable t) {
                        LOG.warn("Failed bulking re-open " + hris.size() + " region(s)", t);
                    }
                }
            });
        }
    }

    @Override
    protected boolean waitUntilDone(long timeout) {
        return true;
    }

    @Override
    protected int getThreadCount() {
        int defaultThreadCount = super.getThreadCount();
        return this.server.getConfiguration().getInt("hbase.bulk.reopen.threadpool.size", defaultThreadCount);
    }

    public boolean bulkReOpen() throws InterruptedException, IOException {
        return this.bulkAssign();
    }

    private void unassign(List<HRegionInfo> regions) throws InterruptedException {
        int waitTime = this.server.getConfiguration().getInt("hbase.bulk.waitbetween.reopen", 0);
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        for (HRegionInfo region : regions) {
            if (this.server.isStopped()) {
                return;
            }
            if (regionStates.isRegionInTransition(region)) continue;
            this.assignmentManager.unassign(region, false);
            while (regionStates.isRegionInTransition(region) && !this.server.isStopped()) {
                regionStates.waitForUpdate(100L);
            }
            if (waitTime <= 0 || this.server.isStopped()) continue;
            Thread.sleep(waitTime);
        }
    }
}

