/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;

@InterfaceAudience.Private
public class GeneralBulkAssigner
extends BulkAssigner {
    private static final Log LOG = LogFactory.getLog(GeneralBulkAssigner.class);
    private Map<ServerName, List<HRegionInfo>> failedPlans = new ConcurrentHashMap<ServerName, List<HRegionInfo>>();
    private ExecutorService pool;
    final Map<ServerName, List<HRegionInfo>> bulkPlan;
    final AssignmentManager assignmentManager;
    final boolean waitTillAllAssigned;

    public GeneralBulkAssigner(Server server, Map<ServerName, List<HRegionInfo>> bulkPlan, AssignmentManager am, boolean waitTillAllAssigned) {
        super(server);
        this.bulkPlan = bulkPlan;
        this.assignmentManager = am;
        this.waitTillAllAssigned = waitTillAllAssigned;
    }

    @Override
    protected String getThreadNamePrefix() {
        return this.server.getServerName() + "-GeneralBulkAssigner";
    }

    @Override
    protected void populatePool(ExecutorService pool) {
        this.pool = pool;
        for (Map.Entry<ServerName, List<HRegionInfo>> e : this.bulkPlan.entrySet()) {
            pool.execute(new SingleServerBulkAssigner(e.getKey(), e.getValue(), this.assignmentManager, this.failedPlans));
        }
    }

    @Override
    protected boolean waitUntilDone(long timeout) throws InterruptedException {
        HashSet<HRegionInfo> regionSet = new HashSet<HRegionInfo>();
        for (List<HRegionInfo> regionList : this.bulkPlan.values()) {
            regionSet.addAll(regionList);
        }
        this.pool.shutdown();
        int serverCount = this.bulkPlan.size();
        int regionCount = regionSet.size();
        long startTime = System.currentTimeMillis();
        long rpcWaitTime = startTime + timeout;
        while (!this.server.isStopped() && !this.pool.isTerminated() && rpcWaitTime > System.currentTimeMillis()) {
            if (this.failedPlans.isEmpty()) {
                this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            this.reassignFailedPlans();
        }
        if (!this.pool.isTerminated()) {
            LOG.warn("bulk assigner is still running after " + (System.currentTimeMillis() - startTime) + "ms, shut it down now");
            List<Runnable> notStarted = this.pool.shutdownNow();
            if (notStarted != null && !notStarted.isEmpty()) {
                this.server.abort("some single server assigner hasn't started yet when the bulk assigner timed out", null);
                return false;
            }
        }
        int reassigningRegions = 0;
        if (!this.failedPlans.isEmpty() && !this.server.isStopped()) {
            reassigningRegions = this.reassignFailedPlans();
        }
        Configuration conf = this.server.getConfiguration();
        long perRegionOpenTimeGuesstimate = conf.getLong("hbase.bulk.assignment.perregion.open.time", 1000L);
        long endTime = Math.max(System.currentTimeMillis(), rpcWaitTime) + perRegionOpenTimeGuesstimate * (long)(reassigningRegions + 1);
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        while (!regionSet.isEmpty() && !this.server.isStopped() && endTime > System.currentTimeMillis()) {
            Iterator regionInfoIterator = regionSet.iterator();
            while (regionInfoIterator.hasNext()) {
                HRegionInfo hri = (HRegionInfo)regionInfoIterator.next();
                if (!regionStates.isRegionOnline(hri) && !regionStates.isRegionInState(hri, RegionState.State.SPLITTING, RegionState.State.SPLIT, RegionState.State.MERGING, RegionState.State.MERGED)) continue;
                regionInfoIterator.remove();
            }
            if (!this.waitTillAllAssigned) break;
            if (regionSet.isEmpty()) continue;
            regionStates.waitForUpdate(100L);
        }
        if (LOG.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            String status = "successfully";
            if (!regionSet.isEmpty()) {
                status = "with " + regionSet.size() + " regions still in transition";
            }
            LOG.debug("bulk assigning total " + regionCount + " regions to " + serverCount + " servers, took " + elapsedTime + "ms, " + status);
        }
        return regionSet.isEmpty();
    }

    @Override
    protected long getTimeoutOnRIT() {
        Configuration conf = this.server.getConfiguration();
        long perRegionOpenTimeGuesstimate = conf.getLong("hbase.bulk.assignment.perregion.open.time", 1000L);
        int maxRegionsPerServer = 1;
        for (List<HRegionInfo> regionList : this.bulkPlan.values()) {
            int size = regionList.size();
            if (size <= maxRegionsPerServer) continue;
            maxRegionsPerServer = size;
        }
        long timeout = perRegionOpenTimeGuesstimate * (long)maxRegionsPerServer + conf.getLong("hbase.regionserver.rpc.startup.waittime", 60000L) + conf.getLong("hbase.bulk.assignment.perregionserver.rpc.waittime", 30000L) * (long)this.bulkPlan.size();
        LOG.debug("Timeout-on-RIT=" + timeout);
        return timeout;
    }

    @Override
    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.warn("Assigning regions in " + t.getName(), e);
            }
        };
    }

    private int reassignFailedPlans() {
        ArrayList reassigningRegions = new ArrayList();
        for (Map.Entry<ServerName, List<HRegionInfo>> e : this.failedPlans.entrySet()) {
            LOG.info("Failed assigning " + e.getValue().size() + " regions to server " + e.getKey() + ", reassigning them");
            reassigningRegions.addAll(this.failedPlans.remove(e.getKey()));
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        for (HRegionInfo region : reassigningRegions) {
            if (regionStates.isRegionOnline(region)) continue;
            this.assignmentManager.invokeAssign(region);
        }
        return reassigningRegions.size();
    }

    static class SingleServerBulkAssigner
    implements Runnable {
        private final ServerName regionserver;
        private final List<HRegionInfo> regions;
        private final AssignmentManager assignmentManager;
        private final Map<ServerName, List<HRegionInfo>> failedPlans;

        SingleServerBulkAssigner(ServerName regionserver, List<HRegionInfo> regions, AssignmentManager am, Map<ServerName, List<HRegionInfo>> failedPlans) {
            this.regionserver = regionserver;
            this.regions = regions;
            this.assignmentManager = am;
            this.failedPlans = failedPlans;
        }

        @Override
        public void run() {
            try {
                if (!this.assignmentManager.assign(this.regionserver, this.regions)) {
                    this.failedPlans.put(this.regionserver, this.regions);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed bulking assigning " + this.regions.size() + " region(s) to " + this.regionserver.getServerName() + ", and continue to bulk assign others", t);
                this.failedPlans.put(this.regionserver, this.regions);
            }
        }
    }
}

