/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

@InterfaceAudience.Private
public class MasterCoprocessorHost
extends CoprocessorHost<MasterEnvironment> {
    private MasterServices masterServices;

    MasterCoprocessorHost(MasterServices services, Configuration conf) {
        super(services);
        this.conf = conf;
        this.masterServices = services;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.master.classes");
    }

    @Override
    public MasterEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        for (Class<?> c : implClass.getInterfaces()) {
            if (!CoprocessorService.class.isAssignableFrom(c)) continue;
            this.masterServices.registerService(((CoprocessorService)((Object)instance)).getService());
        }
        return new MasterEnvironment(implClass, instance, priority, seq, conf, this.masterServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCreateNamespace(NamespaceDescriptor ns) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preCreateNamespace(ctx, ns);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateNamespace(NamespaceDescriptor ns) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postCreateNamespace(ctx, ns);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preDeleteNamespace(String namespaceName) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteNamespace(ctx, namespaceName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteNamespace(String namespaceName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteNamespace(ctx, namespaceName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preModifyNamespace(NamespaceDescriptor ns) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preModifyNamespace(ctx, ns);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyNamespace(NamespaceDescriptor ns) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postModifyNamespace(ctx, ns);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preCreateTable(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postCreateTable(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTableHandler(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preCreateTableHandler(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTableHandler(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postCreateTableHandler(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preModifyTable(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postModifyTable(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTableHandler(TableName tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preModifyTableHandler(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTableHandler(TableName tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postModifyTableHandler(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preAddColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preAddColumn(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postAddColumn(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preAddColumnHandler(TableName tableName, HColumnDescriptor column) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preAddColumnHandler(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumnHandler(TableName tableName, HColumnDescriptor column) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postAddColumnHandler(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preModifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preModifyColumn(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postModifyColumn(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preModifyColumnHandler(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preModifyColumnHandler(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumnHandler(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postModifyColumnHandler(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preDeleteColumn(TableName tableName, byte[] c) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteColumn(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumn(TableName tableName, byte[] c) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteColumn(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preDeleteColumnHandler(TableName tableName, byte[] c) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteColumnHandler(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumnHandler(TableName tableName, byte[] c) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteColumnHandler(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preEnableTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preEnableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEnableTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postEnableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preEnableTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preEnableTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEnableTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postEnableTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDisableTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDisableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDisableTable(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDisableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDisableTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDisableTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDisableTableHandler(TableName tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDisableTableHandler(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preMove(HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preMove(ctx, region, srcServer, destServer);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMove(HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postMove(ctx, region, srcServer, destServer);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preAssign(HRegionInfo regionInfo) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preAssign(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAssign(HRegionInfo regionInfo) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postAssign(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preUnassign(HRegionInfo regionInfo, boolean force) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preUnassign(ctx, regionInfo, force);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnassign(HRegionInfo regionInfo, boolean force) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postUnassign(ctx, regionInfo, force);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRegionOffline(HRegionInfo regionInfo) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preRegionOffline(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRegionOffline(HRegionInfo regionInfo) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postRegionOffline(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBalance() throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preBalance(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBalance(List<RegionPlan> plans) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postBalance(ctx, plans);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBalanceSwitch(boolean b) throws IOException {
        boolean balance = b;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                balance = ((MasterObserver)env.getInstance()).preBalanceSwitch(ctx, balance);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postBalanceSwitch(boolean oldValue, boolean newValue) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postBalanceSwitch(ctx, oldValue, newValue);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preShutdown() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preShutdown(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preStopMaster() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preStopMaster(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMasterInitialization() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preMasterInitialization(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postStartMaster() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postStartMaster(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCloneSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preCloneSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloneSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postCloneSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRestoreSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRestoreSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preDeleteSnapshot(ctx, snapshot);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postDeleteSnapshot(ctx, snapshot);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preGetTableDescriptors(List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).preGetTableDescriptors(ctx, tableNamesList, descriptors);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableDescriptors(List<HTableDescriptor> descriptors) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((MasterObserver)env.getInstance()).postGetTableDescriptors(ctx, descriptors);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    static class MasterEnvironment
    extends CoprocessorHost.Environment
    implements MasterCoprocessorEnvironment {
        private MasterServices masterServices;

        public MasterEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, MasterServices services) {
            super(impl, priority, seq, conf);
            this.masterServices = services;
        }

        @Override
        public MasterServices getMasterServices() {
            return this.masterServices;
        }
    }
}

