/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.master.MetricsMasterFileSystemSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsMasterFilesystemSourceImpl
extends BaseSourceImpl
implements MetricsMasterFileSystemSource {
    private MetricMutableHistogram splitSizeHisto;
    private MetricMutableHistogram splitTimeHisto;
    private MetricMutableHistogram metaSplitTimeHisto;
    private MetricMutableHistogram metaSplitSizeHisto;

    public MetricsMasterFilesystemSourceImpl() {
        this("FileSystem", "Metrics about HBase master file system.", "master", "Master,sub=FileSystem");
    }

    public MetricsMasterFilesystemSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.splitSizeHisto = this.metricsRegistry.newHistogram("hlogSplitSize", "Size of HLog files being split");
        this.splitTimeHisto = this.metricsRegistry.newHistogram("hlogSplitTime", "Time it takes to finish HLog.splitLog()");
        this.metaSplitTimeHisto = this.metricsRegistry.newHistogram("metaHlogSplitTime", "Time it takes to finish splitMetaLog()");
        this.metaSplitSizeHisto = this.metricsRegistry.newHistogram("metaHlogSplitSize", "Size of hbase:meta HLog files being split");
    }

    @Override
    public void updateSplitTime(long time) {
        this.splitTimeHisto.add(time);
    }

    @Override
    public void updateSplitSize(long size) {
        this.splitSizeHisto.add(size);
    }

    @Override
    public void updateMetaWALSplitTime(long time) {
        this.metaSplitTimeHisto.add(time);
    }

    @Override
    public void updateMetaWALSplitSize(long size) {
        this.metaSplitSizeHisto.add(size);
    }
}

