/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

class MockRegionServer
implements AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
RegionServerServices {
    private final ServerName sn;
    private final ZooKeeperWatcher zkw;
    private final Configuration conf;
    private final Random random = new Random();
    private final Map<byte[], Map<byte[], Result>> gets = new TreeMap<byte[], Map<byte[], Result>>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Result[]> nexts = new TreeMap<byte[], Result[]>(Bytes.BYTES_COMPARATOR);
    private final Map<Long, RegionNameAndIndex> scannersAndOffsets = new HashMap<Long, RegionNameAndIndex>();

    MockRegionServer(Configuration conf, ServerName sn) throws ZooKeeperConnectionException, IOException {
        this.sn = sn;
        this.conf = conf;
        this.zkw = new ZooKeeperWatcher(conf, sn.toString(), this, true);
    }

    void setGetResult(byte[] regionName, byte[] row, Result r) {
        Map<byte[], Result> value = this.gets.get(regionName);
        if (value == null) {
            value = new TreeMap<byte[], Result>(Bytes.BYTES_COMPARATOR);
            this.gets.put(regionName, value);
        }
        value.put(row, r);
    }

    void setNextResults(byte[] regionName, Result[] rs) {
        this.nexts.put(regionName, rs);
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    @Override
    public void abort(String why, Throwable e) {
        throw new RuntimeException(this.sn + ": " + why, e);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        long scannerId = this.random.nextLong();
        this.scannersAndOffsets.put(scannerId, new RegionNameAndIndex(regionName));
        return scannerId;
    }

    public Result next(long scannerId) throws IOException {
        RegionNameAndIndex rnai = this.scannersAndOffsets.get(scannerId);
        int index = rnai.getThenIncrement();
        Result[] results = this.nexts.get(rnai.getRegionName());
        if (results == null) {
            return null;
        }
        return index < results.length ? results[index] : null;
    }

    public Result[] next(long scannerId, int numberOfRows) throws IOException {
        Result[] resultArray;
        Result r = this.next(scannerId);
        if (r == null) {
            resultArray = null;
        } else {
            Result[] resultArray2 = new Result[1];
            resultArray = resultArray2;
            resultArray2[0] = r;
        }
        return resultArray;
    }

    public void close(long scannerId) throws IOException {
        this.scannersAndOffsets.remove(scannerId);
    }

    @Override
    public void stop(String why) {
        this.zkw.close();
    }

    @Override
    public void addToOnlineRegions(HRegion r) {
    }

    @Override
    public boolean removeFromOnlineRegions(HRegion r, ServerName destination) {
        return false;
    }

    @Override
    public HRegion getFromOnlineRegions(String encodedRegionName) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zkw;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return null;
    }

    @Override
    public ServerName getServerName() {
        return this.sn;
    }

    @Override
    public boolean isStopping() {
        return false;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return null;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return null;
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return new TableLockManager.NullTableLockManager();
    }

    @Override
    public void postOpenDeployTasks(HRegion r, CatalogTracker ct) throws KeeperException, IOException {
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return null;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return null;
    }

    @Override
    public FileSystem getFileSystem() {
        return null;
    }

    @Override
    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        Map<byte[], Result> m = this.gets.get(regionName);
        ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
        if (m != null) {
            byte[] row = request.getGet().getRow().toByteArray();
            builder.setResult(ProtobufUtil.toResult(m.get(row)));
        }
        return builder.build();
    }

    @Override
    public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
        return null;
    }

    @Override
    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScan()) {
                byte[] regionName = request.getRegion().getValue().toByteArray();
                builder.setScannerId(this.openScanner(regionName, null));
                builder.setMoreResults(true);
            } else {
                long scannerId = request.getScannerId();
                Result result = this.next(scannerId);
                if (result != null) {
                    builder.addCellsPerResult(result.size());
                    ArrayList<Result> results = new ArrayList<Result>(1);
                    results.add(result);
                    ((PayloadCarryingRpcController)controller).setCellScanner(CellUtil.createCellScanner(results));
                    builder.setMoreResults(true);
                } else {
                    builder.setMoreResults(false);
                    this.close(scannerId);
                }
            }
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        return builder.build();
    }

    @Override
    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        return null;
    }

    @Override
    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return null;
    }

    @Override
    public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
        builder.setRegionInfo(HRegionInfo.convert(HRegionInfo.FIRST_META_REGIONINFO));
        return builder.build();
    }

    @Override
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        return null;
    }

    @Override
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        return null;
    }

    @Override
    public List<HRegion> getOnlineRegions(TableName tableName) throws IOException {
        return null;
    }

    @Override
    public Leases getLeases() {
        return null;
    }

    @Override
    public HLog getWAL(HRegionInfo regionInfo) throws IOException {
        return null;
    }

    @Override
    public ExecutorService getExecutorService() {
        return null;
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    @Override
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    @Override
    public Map<String, HRegion> getRecoveringRegions() {
        return null;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param) {
        return 0;
    }

    @Override
    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        return null;
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return null;
    }

    class RegionNameAndIndex {
        private final byte[] regionName;
        private int index = 0;

        RegionNameAndIndex(byte[] regionName) {
            this.regionName = regionName;
        }

        byte[] getRegionName() {
            return this.regionName;
        }

        int getThenIncrement() {
            int currentIndex = this.index++;
            return currentIndex;
        }
    }
}

