/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClockSkewDetection {
    private static final Log LOG = LogFactory.getLog(TestClockSkewDetection.class);

    @Test
    public void testClockSkewDetection() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        ServerManager sm = new ServerManager(new Server(){

            @Override
            public CatalogTracker getCatalogTracker() {
                return null;
            }

            @Override
            public Configuration getConfiguration() {
                return conf;
            }

            @Override
            public ServerName getServerName() {
                return null;
            }

            @Override
            public ZooKeeperWatcher getZooKeeper() {
                return null;
            }

            @Override
            public void abort(String why, Throwable e) {
            }

            @Override
            public boolean isAborted() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return false;
            }

            @Override
            public void stop(String why) {
            }
        }, null, false);
        LOG.debug("regionServerStartup 1");
        InetAddress ia1 = InetAddress.getLocalHost();
        sm.regionServerStartup(ia1, 1234, -1L, System.currentTimeMillis());
        Configuration c = HBaseConfiguration.create();
        long maxSkew = c.getLong("hbase.master.maxclockskew", 30000L);
        long warningSkew = c.getLong("hbase.master.warningclockskew", 1000L);
        try {
            LOG.debug("Test: Master Time > Region Server Time");
            LOG.debug("regionServerStartup 2");
            InetAddress ia2 = InetAddress.getLocalHost();
            sm.regionServerStartup(ia2, 1235, -1L, System.currentTimeMillis() - maxSkew * 2L);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info("Recieved expected exception: " + e);
        }
        try {
            LOG.debug("Test: Master Time < Region Server Time");
            LOG.debug("regionServerStartup 3");
            InetAddress ia3 = InetAddress.getLocalHost();
            sm.regionServerStartup(ia3, 1236, -1L, System.currentTimeMillis() + maxSkew * 2L);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info("Recieved expected exception: " + e);
        }
        LOG.debug("regionServerStartup 4");
        InetAddress ia4 = InetAddress.getLocalHost();
        sm.regionServerStartup(ia4, 1237, -1L, System.currentTimeMillis() - warningSkew * 2L);
        LOG.debug("regionServerStartup 5");
        InetAddress ia5 = InetAddress.getLocalHost();
        sm.regionServerStartup(ia5, 1238, -1L, System.currentTimeMillis() + warningSkew * 2L);
    }
}

