/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterFailover {
    private static final Log LOG = LogFactory.getLog(TestMasterFailover.class);

    @Test(timeout=240000L)
    public void testMasterFailoverWithMockedRIT() throws Exception {
        byte[] bytes;
        RegionTransition rt;
        boolean NUM_MASTERS = true;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes("family");
        byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes("aaa"), Bytes.toBytes("bbb"), Bytes.toBytes("ccc"), Bytes.toBytes("ddd"), Bytes.toBytes("eee"), Bytes.toBytes("fff"), Bytes.toBytes("ggg"), Bytes.toBytes("hhh"), Bytes.toBytes("iii"), Bytes.toBytes("jjj")};
        byte[] enabledTable = Bytes.toBytes("enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(TableName.valueOf(enabledTable));
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        FileSystem filesystem = FileSystem.get(conf);
        Path rootdir = FSUtils.getRootDir(conf);
        FSTableDescriptors fstd = new FSTableDescriptors(filesystem, rootdir);
        fstd.createTableDescriptor(htdEnabled);
        HRegionInfo hriEnabled = new HRegionInfo(htdEnabled.getTableName(), null, null);
        this.createRegion(hriEnabled, rootdir, conf, htdEnabled);
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        TableName disabledTable = TableName.valueOf("disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        fstd.createTableDescriptor(htdDisabled);
        HRegionInfo hriDisabled = new HRegionInfo(htdDisabled.getTableName(), null, null);
        this.createRegion(hriDisabled, rootdir, conf, htdDisabled);
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        TableName tableWithMergingRegions = TableName.valueOf("tableWithMergingRegions");
        TEST_UTIL.createTable(tableWithMergingRegions, FAMILY, (byte[][])new byte[][]{Bytes.toBytes("m")});
        this.log("Regions in hbase:meta and namespace have been created");
        Assert.assertEquals((long)4L, (long)cluster.countServedRegions());
        AssignmentManager am = master.getAssignmentManager();
        RegionStates regionStates = am.getRegionStates();
        List<HRegionInfo> mergingRegions = regionStates.getRegionsOfTable(tableWithMergingRegions);
        Assert.assertEquals((long)2L, (long)mergingRegions.size());
        HRegionInfo a = mergingRegions.get(0);
        HRegionInfo b = mergingRegions.get(1);
        HRegionInfo newRegion = RegionMergeTransaction.getMergedRegionInfo(a, b);
        ServerName mergingServer = regionStates.getRegionServerOfRegion(a);
        ServerName serverB = regionStates.getRegionServerOfRegion(b);
        if (!serverB.equals(mergingServer)) {
            RegionPlan plan = new RegionPlan(b, serverB, mergingServer);
            am.balance(plan);
            Assert.assertTrue((boolean)am.waitForAssignment(b));
        }
        HRegionServer hrs = cluster.getRegionServer(0);
        ServerName serverName = hrs.getServerName();
        HRegionInfo closingRegion = enabledRegions.remove(0);
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(closingRegion);
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, serverName));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, serverName));
            master.assignRegion(hri);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT(zkw);
        this.log("Assignment completed");
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTable zktable = new ZKTable(zkw);
        zktable.setDisabledTable(disabledTable);
        HRegionInfo region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline(zkw, region, serverName);
        regionsThatShouldBeOnline.add(closingRegion);
        ZKAssign.createNodeClosing(zkw, closingRegion, serverName);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing(zkw, region, serverName);
        ZKAssign.transitionNodeClosed(zkw, region, serverName, version);
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing(zkw, region, serverName);
        ZKAssign.transitionNodeClosed(zkw, region, serverName, version);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline(zkw, region, serverName);
        ProtobufUtil.openRegion(hrs, hrs.getServerName(), region);
        while ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline(zkw, region, serverName);
        ProtobufUtil.openRegion(hrs, hrs.getServerName(), region);
        while ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        RegionMergeTransaction.createNodeMerging(zkw, newRegion, mergingServer, a, b);
        this.log("Done mocking data up in ZK");
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        regionStates = master.getAssignmentManager().getRegionStates();
        Assert.assertTrue((boolean)regionStates.isRegionInState(a, RegionState.State.MERGING));
        Assert.assertTrue((boolean)regionStates.isRegionInState(b, RegionState.State.MERGING));
        Assert.assertTrue((boolean)regionStates.isRegionInState(newRegion, RegionState.State.MERGING_NEW));
        ZKAssign.deleteNodeFailSilent(zkw, newRegion);
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(zkw);
        this.log("No more RIT in ZK, now doing final test verification");
        TreeSet<HRegionInfo> onlineRegions = new TreeSet<HRegionInfo>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            onlineRegions.addAll(ProtobufUtil.getOnlineRegions(rst.getRegionServer()));
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            if (onlineRegions.contains(hri)) {
                LOG.debug(hri);
            }
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMasterFailoverWithMockedRITOnDeadRS() throws Exception {
        byte[] bytes;
        RegionTransition rt;
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 2);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.error("Fatal ZK Error: " + why, e);
                Assert.assertFalse((String)"Fatal ZK error", (boolean)true);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        });
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes("family");
        byte[][] SPLIT_KEYS = TEST_UTIL.getRegionSplitStartKeys(Bytes.toBytes("aaa"), Bytes.toBytes("zzz"), 30);
        byte[] enabledTable = Bytes.toBytes("enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(TableName.valueOf(enabledTable));
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        FileSystem filesystem = FileSystem.get(conf);
        Path rootdir = FSUtils.getRootDir(conf);
        FSTableDescriptors fstd = new FSTableDescriptors(filesystem, rootdir);
        fstd.createTableDescriptor(htdEnabled);
        HRegionInfo hriEnabled = new HRegionInfo(htdEnabled.getTableName(), null, null);
        this.createRegion(hriEnabled, rootdir, conf, htdEnabled);
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        TableName disabledTable = TableName.valueOf("disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        fstd.createTableDescriptor(htdDisabled);
        HRegionInfo hriDisabled = new HRegionInfo(htdDisabled.getTableName(), null, null);
        this.createRegion(hriDisabled, rootdir, conf, htdDisabled);
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        this.log("Regions in hbase:meta and Namespace have been created");
        Assert.assertEquals((long)2L, (long)cluster.countServedRegions());
        List<JVMClusterUtil.RegionServerThread> regionservers = cluster.getRegionServerThreads();
        HRegionServer hrs = regionservers.get(0).getRegionServer();
        JVMClusterUtil.RegionServerThread hrsDeadThread = regionservers.get(1);
        HRegionServer hrsDead = hrsDeadThread.getRegionServer();
        ServerName deadServerName = hrsDead.getServerName();
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.addAll(enabledRegions.subList(0, 6));
        enabledRegions.removeAll(enabledAndAssignedRegions);
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.addAll(disabledRegions.subList(0, 6));
        disabledRegions.removeAll(disabledAndAssignedRegions);
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, hrs.getServerName()));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, hrs.getServerName()));
            master.assignRegion(hri);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT(zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
        this.log("Assignment completed");
        Assert.assertTrue((String)" Table must be enabled.", (boolean)master.getAssignmentManager().getZKTable().isEnabledTable(TableName.valueOf("enabledTable")));
        ArrayList<HRegionInfo> enabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        enabledAndOnDeadRegions.addAll(enabledRegions.subList(0, 6));
        enabledRegions.removeAll(enabledAndOnDeadRegions);
        ArrayList<HRegionInfo> disabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        disabledAndOnDeadRegions.addAll(disabledRegions.subList(0, 6));
        disabledRegions.removeAll(disabledAndOnDeadRegions);
        for (HRegionInfo hri : enabledAndOnDeadRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, deadServerName));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndOnDeadRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new RegionPlan(hri, null, deadServerName));
            master.assignRegion(hri);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT(zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
        this.log("Assignment completed");
        this.verifyRegionLocation(hrs, enabledAndAssignedRegions);
        this.verifyRegionLocation(hrs, disabledAndAssignedRegions);
        this.verifyRegionLocation(hrsDead, enabledAndOnDeadRegions);
        this.verifyRegionLocation(hrsDead, disabledAndOnDeadRegions);
        Assert.assertTrue((String)" Didn't get enough regions of enabledTalbe on live rs.", (enabledAndAssignedRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of disalbedTable on live rs.", (disabledAndAssignedRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of enabledTalbe on dead rs.", (enabledAndOnDeadRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of disalbedTable on dead rs.", (disabledAndOnDeadRegions.size() >= 2 ? 1 : 0) != 0);
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTable zktable = new ZKTable(zkw);
        zktable.setDisabledTable(disabledTable);
        Assert.assertTrue((String)" The enabled table should be identified on master fail over.", (boolean)zktable.isEnabledTable(TableName.valueOf("enabledTable")));
        HRegionInfo region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeClosing(zkw, region, deadServerName);
        LOG.debug("\n\nRegion of enabled table was CLOSING on dead RS\n" + region + "\n\n");
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeClosing(zkw, region, deadServerName);
        LOG.debug("\n\nRegion of disabled table was CLOSING on dead RS\n" + region + "\n\n");
        region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing(zkw, region, deadServerName);
        ZKAssign.transitionNodeClosed(zkw, region, deadServerName, version);
        LOG.debug("\n\nRegion of enabled table was CLOSED on dead RS\n" + region + "\n\n");
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing(zkw, region, deadServerName);
        ZKAssign.transitionNodeClosed(zkw, region, deadServerName, version);
        LOG.debug("\n\nRegion of disabled table was CLOSED on dead RS\n" + region + "\n\n");
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ZKAssign.transitionNodeOpening(zkw, region, deadServerName);
        LOG.debug("\n\nRegion of enabled table was OPENING on dead RS\n" + region + "\n\n");
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ZKAssign.transitionNodeOpening(zkw, region, deadServerName);
        LOG.debug("\n\nRegion of disabled table was OPENING on dead RS\n" + region + "\n\n");
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ProtobufUtil.openRegion(hrsDead, hrsDead.getServerName(), region);
        while ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        LOG.debug("\n\nRegion of enabled table was OPENED on dead RS\n" + region + "\n\n");
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ProtobufUtil.openRegion(hrsDead, hrsDead.getServerName(), region);
        while ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        LOG.debug("\n\nRegion of disabled table was OPENED on dead RS\n" + region + "\n\n");
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ProtobufUtil.openRegion(hrsDead, hrsDead.getServerName(), region);
        while (true) {
            if ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode(zkw, region.getEncodedName(), rt.getServerName());
        LOG.debug("DELETED " + rt);
        LOG.debug("\n\nRegion of enabled table was open at steady-state on dead RS\n" + region + "\n\n");
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline(zkw, region, deadServerName);
        ProtobufUtil.openRegion(hrsDead, hrsDead.getServerName(), region);
        while (true) {
            if ((rt = RegionTransition.parseFrom(bytes = ZKAssign.getData(zkw, region.getEncodedName()))) != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode(zkw, region.getEncodedName(), rt.getServerName());
        LOG.debug("\n\nRegion of disabled table was open at steady-state on dead RS\n" + region + "\n\n");
        this.log("Done mocking data up in ZK");
        this.log("Killing RS " + deadServerName);
        hrsDead.abort("Killing for unit test");
        this.log("RS " + deadServerName + " killed");
        while (hrsDeadThread.isAlive()) {
            Threads.sleep(10L);
        }
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        this.log("Master is ready");
        while (master.getServerManager().areDeadServersInProgress()) {
            Thread.sleep(10L);
        }
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(zkw);
        this.log("No more RIT in ZK");
        long now = System.currentTimeMillis();
        long maxTime = 120000L;
        boolean done = master.assignmentManager.waitUntilNoRegionsInTransition(maxTime);
        if (!done) {
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            LOG.info("rit=" + regionStates.getRegionsInTransition());
        }
        long elapsed = System.currentTimeMillis() - now;
        Assert.assertTrue((String)("Elapsed=" + elapsed + ", maxTime=" + maxTime + ", done=" + done), (elapsed < maxTime ? 1 : 0) != 0);
        this.log("No more RIT in RIT map, doing final test verification");
        TreeSet<HRegionInfo> onlineRegions = new TreeSet<HRegionInfo>();
        now = System.currentTimeMillis();
        maxTime = 30000L;
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            try {
                HRegionServer rs = rst.getRegionServer();
                while (!rs.getRegionsInTransitionInRS().isEmpty()) {
                    elapsed = System.currentTimeMillis() - now;
                    Assert.assertTrue((String)"Test timed out in getting online regions", (elapsed < maxTime ? 1 : 0) != 0);
                    if (rs.isAborted() || rs.isStopped()) break;
                    Thread.sleep(100L);
                }
                onlineRegions.addAll(ProtobufUtil.getOnlineRegions(rs));
            }
            catch (RegionServerStoppedException e) {
                LOG.info("Got RegionServerStoppedException", e);
            }
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((String)("region=" + hri.getRegionNameAsString() + ", " + ((Object)onlineRegions).toString()), (boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    private void verifyRegionLocation(HRegionServer hrs, List<HRegionInfo> regions) throws IOException {
        List<HRegionInfo> tmpOnlineRegions = ProtobufUtil.getOnlineRegions(hrs);
        Iterator<HRegionInfo> itr = regions.iterator();
        while (itr.hasNext()) {
            HRegionInfo tmp = itr.next();
            if (tmpOnlineRegions.contains(tmp)) continue;
            itr.remove();
        }
    }

    HRegion createRegion(HRegionInfo hri, Path rootdir, Configuration c, HTableDescriptor htd) throws IOException {
        HRegion r = HRegion.createHRegion(hri, rootdir, c, htd);
        HRegion.closeHRegion(r);
        return r;
    }

    private void log(String string) {
        LOG.info("\n\n" + string + " \n\n");
    }

    @Test(timeout=180000L)
    public void testShouldCheckMasterFailOverWhenMETAIsInOpenedState() throws Exception {
        LOG.info("Starting testShouldCheckMasterFailOverWhenMETAIsInOpenedState");
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.master.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = cluster.getRegionServerThreads();
        int count = -1;
        HRegion metaRegion = null;
        for (JVMClusterUtil.RegionServerThread regionServerThread : regionServerThreads) {
            HRegionServer regionServer = regionServerThread.getRegionServer();
            metaRegion = regionServer.getOnlineRegion(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
            ++count;
            regionServer.abort("");
            if (null == metaRegion) continue;
            break;
        }
        HRegionServer regionServer = cluster.getRegionServer(count);
        TEST_UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(TEST_UTIL, metaRegion, regionServer.getServerName());
        LOG.info("Staring cluster for second time");
        TEST_UTIL.startMiniHBaseCluster(1, 2);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        while (!master.isInitialized()) {
            Thread.sleep(100L);
        }
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(zkw);
        zkw.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=240000L)
    public void testOfflineRegionReAssginedAfterMasterRestart() throws Exception {
        ServerManager serverManager;
        TableName table = TableName.valueOf("testOfflineRegionReAssginedAfterMasterRestart");
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 2);
        this.log("Cluster started");
        TEST_UTIL.createTable(table, Bytes.toBytes("family"));
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        HRegionInfo hri = regionStates.getRegionsOfTable(table).get(0);
        ServerName serverName = regionStates.getRegionServerOfRegion(hri);
        TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        ServerName dstName = null;
        for (ServerName tmpServer : master.serverManager.getOnlineServers().keySet()) {
            if (tmpServer.equals(serverName)) continue;
            dstName = tmpServer;
            break;
        }
        Assert.assertTrue((dstName != null ? 1 : 0) != 0);
        TEST_UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        ZKAssign.createNodeOffline(zkw, hri, dstName);
        Stat stat = new Stat();
        byte[] data = ZKAssign.getDataNoWatch(zkw, hri.getEncodedName(), stat);
        Assert.assertTrue((data != null ? 1 : 0) != 0);
        RegionTransition rt = RegionTransition.parseFrom(data);
        Assert.assertTrue((rt.getEventType() == EventType.M_ZK_REGION_OFFLINE ? 1 : 0) != 0);
        LOG.info(hri.getEncodedName() + " region is in offline state with source server=" + serverName + " and dst server=" + dstName);
        TEST_UTIL.startMiniHBaseCluster(1, 2);
        while ((master = TEST_UTIL.getHBaseCluster().getMaster()) == null || !master.isInitialized() || (serverManager = master.getServerManager()).areDeadServersInProgress()) {
            Thread.sleep(200L);
        }
        master = TEST_UTIL.getHBaseCluster().getMaster();
        master.getAssignmentManager().waitForAssignment(hri);
        regionStates = master.getAssignmentManager().getRegionStates();
        RegionState newState = regionStates.getRegionState(hri);
        Assert.assertTrue((boolean)newState.isOpened());
    }

    @Test(timeout=240000L)
    public void testSimpleMasterFailover() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        int numActive = 0;
        int activeIndex = -1;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        LOG.info("Active master " + activeName);
        Assert.assertNotNull((Object)active);
        ClusterStatus status = active.getClusterStatus();
        Assert.assertTrue((boolean)status.getMaster().equals(activeName));
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)2L, (long)status.getBackupMasters().size());
        int backupIndex = activeIndex == 0 ? 1 : activeIndex - 1;
        HMaster master = cluster.getMaster(backupIndex);
        LOG.debug("\n\nStopping a backup master: " + master.getServerName() + "\n");
        cluster.stopMaster(backupIndex, false);
        cluster.waitOnMaster(backupIndex);
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            Assert.assertTrue((boolean)activeName.equals(masterThreads.get(i).getMaster().getServerName()));
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)2L, (long)masterThreads.size());
        int rsCount = masterThreads.get(activeIndex).getMaster().getClusterStatus().getServersSize();
        LOG.info("Active master " + active.getServerName() + " managing " + rsCount + " regions servers");
        Assert.assertEquals((long)3L, (long)rsCount);
        Assert.assertNotNull((Object)active);
        status = active.getClusterStatus();
        Assert.assertTrue((boolean)status.getMaster().equals(activeName));
        Assert.assertEquals((long)1L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)1L, (long)status.getBackupMasters().size());
        LOG.debug("\n\nStopping the active master " + active.getServerName() + "\n");
        cluster.stopMaster(activeIndex, false);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        LOG.debug("\n\nVerifying backup master is now active\n");
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        active = masterThreads.get(0).getMaster();
        Assert.assertNotNull((Object)active);
        status = active.getClusterStatus();
        ServerName mastername = status.getMaster();
        Assert.assertTrue((boolean)mastername.equals(active.getServerName()));
        Assert.assertTrue((boolean)active.isActiveMaster());
        Assert.assertEquals((long)0L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)0L, (long)status.getBackupMasters().size());
        int rss = status.getServersSize();
        LOG.info("Active master " + mastername.getServerName() + " managing " + rss + " region servers");
        Assert.assertEquals((long)3L, (long)rss);
        TEST_UTIL.shutdownMiniCluster();
    }
}

