/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterFileSystem {
    private static final Log LOG = LogFactory.getLog(TestMasterFileSystem.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFsUriSetProperly() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        Path masterRoot = FSUtils.getRootDir(fs.conf);
        Path rootDir = FSUtils.getRootDir(fs.getFileSystem().getConf());
        LOG.debug("from fs uri:" + FileSystem.getDefaultUri(fs.getFileSystem().getConf()));
        LOG.debug("from configuration uri:" + FileSystem.getDefaultUri(fs.conf));
        Assert.assertEquals((Object)masterRoot, (Object)rootDir);
    }

    @Test
    public void testRemoveStaleRecoveringRegionsDuringMasterInitialization() throws Exception {
        if (!UTIL.getConfiguration().getBoolean("hbase.master.distributed.log.replay", false)) {
            return;
        }
        LOG.info("Starting testRemoveStaleRecoveringRegionsDuringMasterInitialization");
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        String failedRegion = "failedRegoin1";
        String staleRegion = "staleRegion";
        ServerName inRecoveryServerName = ServerName.valueOf("mgr,1,1");
        ServerName previouselyFaildServerName = ServerName.valueOf("previous,1,1");
        String walPath = "/hbase/data/.logs/" + inRecoveryServerName.getServerName() + "-splitting/test";
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(UTIL);
        zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName(zkw, walPath), new SplitLogTask.Owned(inRecoveryServerName).toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String staleRegionPath = ZKUtil.joinZNode(zkw.recoveringRegionsZNode, staleRegion);
        ZKUtil.createWithParents(zkw, staleRegionPath);
        String inRecoveringRegionPath = ZKUtil.joinZNode(zkw.recoveringRegionsZNode, failedRegion);
        inRecoveringRegionPath = ZKUtil.joinZNode(inRecoveringRegionPath, inRecoveryServerName.getServerName());
        ZKUtil.createWithParents(zkw, inRecoveringRegionPath);
        HashSet<ServerName> servers = new HashSet<ServerName>();
        servers.add(previouselyFaildServerName);
        fs.removeStaleRecoveringRegionsFromZK(servers);
        Assert.assertFalse((ZKUtil.checkExists(zkw, staleRegionPath) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, inRecoveringRegionPath) != -1 ? 1 : 0) != 0);
        ZKUtil.deleteChildrenRecursively(zkw, zkw.recoveringRegionsZNode);
        ZKUtil.deleteChildrenRecursively(zkw, zkw.splitLogZNode);
        zkw.close();
    }
}

