/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterMetrics {
    private static final Log LOG = LogFactory.getLog(TestMasterMetrics.class);
    private static final MetricsAssertHelper metricsHelper = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static MiniHBaseCluster cluster;
    private static HMaster master;
    private static HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info("Starting cluster");
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(1, 1, 1, null, HMaster.class, MyRegionServer.class);
        cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        master = cluster.getMaster();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testClusterRequests() throws Exception {
        RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
        ServerName serverName = cluster.getRegionServer(0).getServerName();
        request.setServer(ProtobufUtil.toServerName(serverName));
        MetricsMasterSource masterSource = master.getMetrics().getMetricsSource();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().setTotalNumberOfRequests(10000).build();
        masterSource.init();
        request.setLoad(sl);
        master.regionServerReport(null, request.build());
        metricsHelper.assertCounter("cluster_requests", 10000L, masterSource);
        sl = ClusterStatusProtos.ServerLoad.newBuilder().setTotalNumberOfRequests(15000).build();
        request.setLoad(sl);
        master.regionServerReport(null, request.build());
        metricsHelper.assertCounter("cluster_requests", 15000L, masterSource);
        master.regionServerReport(null, request.build());
        metricsHelper.assertCounter("cluster_requests", 15000L, masterSource);
        master.stopMaster();
    }

    @Test
    public void testDefaultMasterMetrics() throws Exception {
        MetricsMasterSource masterSource = master.getMetrics().getMetricsSource();
        metricsHelper.assertGauge("numRegionServers", 1L, (BaseSource)masterSource);
        metricsHelper.assertGauge("averageLoad", 2L, (BaseSource)masterSource);
        metricsHelper.assertGauge("numDeadRegionServers", 0L, (BaseSource)masterSource);
        metricsHelper.assertGauge("masterStartTime", master.getMasterStartTime(), (BaseSource)masterSource);
        metricsHelper.assertGauge("masterActiveTime", master.getMasterActiveTime(), (BaseSource)masterSource);
        metricsHelper.assertTag("isActiveMaster", "true", masterSource);
        metricsHelper.assertTag("serverName", master.getServerName().toString(), masterSource);
        metricsHelper.assertTag("clusterId", master.getClusterId(), masterSource);
        metricsHelper.assertTag("zookeeperQuorum", master.getZooKeeper().getQuorum(), masterSource);
    }

    private static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        @Override
        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) {
        }
    }
}

