/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestartCluster {
    private static final Log LOG = LogFactory.getLog(TestRestartCluster.class);
    private HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes("master_transitions");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("a")};
    private static final byte[][] TABLES = new byte[][]{Bytes.toBytes("restartTableOne"), Bytes.toBytes("restartTableTwo"), Bytes.toBytes("restartTableThree")};
    private static final byte[] FAMILY = Bytes.toBytes("family");

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testRestartClusterAfterKill() throws Exception {
        this.UTIL.startMiniZKCluster();
        ZooKeeperWatcher zooKeeper = new ZooKeeperWatcher(this.UTIL.getConfiguration(), "cluster1", null, true);
        String unassignedZNode = zooKeeper.assignmentZNode;
        ZKUtil.createAndFailSilent(zooKeeper, unassignedZNode);
        ServerName sn = ServerName.valueOf("master", 1, System.currentTimeMillis());
        ZKAssign.createNodeOffline(zooKeeper, HRegionInfo.FIRST_META_REGIONINFO, sn);
        LOG.debug("Created UNASSIGNED zNode for ROOT and hbase:meta regions in state " + (Object)((Object)EventType.M_ZK_REGION_OFFLINE));
        LOG.info("Starting HBase cluster...");
        this.UTIL.startMiniCluster(2);
        this.UTIL.createTable(TABLENAME, FAMILIES);
        LOG.info("Created a table, waiting for table to be available...");
        this.UTIL.waitTableAvailable(TABLENAME, 60000L);
        LOG.info("Master deleted unassigned region and started up successfully.");
    }

    @Test(timeout=300000L)
    public void testClusterRestart() throws Exception {
        this.UTIL.startMiniCluster(3);
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep(1L);
        }
        LOG.info("\n\nCreating tables");
        for (byte[] TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (byte[] TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        List<HRegionInfo> allRegions = MetaScanner.listAllRegions(this.UTIL.getConfiguration(), true);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nShutting down cluster");
        this.UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time");
        this.UTIL.restartHBaseCluster(3);
        allRegions = MetaScanner.listAllRegions(new Configuration(this.UTIL.getConfiguration()), true);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nWaiting for tables to be available");
        for (byte[] TABLE : TABLES) {
            try {
                this.UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info("Table already exists as expected");
            }
            this.UTIL.waitTableAvailable(TABLE);
        }
    }
}

