/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.MetricsBalancerSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsBalancerSourceImpl
extends BaseSourceImpl
implements MetricsBalancerSource {
    private MetricMutableHistogram blanceClusterHisto;
    private MetricMutableCounterLong miscCount;

    public MetricsBalancerSourceImpl() {
        this("Balancer", "Metrics about HBase master balancer", "master", "Master,sub=Balancer");
    }

    public MetricsBalancerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.blanceClusterHisto = this.metricsRegistry.newHistogram("balancerCluster");
        this.miscCount = this.metricsRegistry.newCounter("miscInvocationCount", "", 0L);
    }

    @Override
    public void updateBalanceCluster(long time) {
        this.blanceClusterHisto.add(time);
    }

    @Override
    public void incrMiscInvocations() {
        this.miscCount.incr();
    }
}

