/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaServerShutdownHandler
extends ServerShutdownHandler {
    private static final Log LOG = LogFactory.getLog(MetaServerShutdownHandler.class);
    private AtomicInteger eventExceptionCount = new AtomicInteger(0);
    @VisibleForTesting
    static final int SHOW_STRACKTRACE_FREQUENCY = 100;

    public MetaServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName) {
        super(server, services, deadServers, serverName, EventType.M_META_SERVER_SHUTDOWN, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        boolean gotException = true;
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            try {
                if (this.shouldSplitHlog) {
                    LOG.info("Splitting hbase:meta logs for " + this.serverName);
                    if (this.distributedLogReplay) {
                        HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
                        regions.add(HRegionInfo.FIRST_META_REGIONINFO);
                        this.services.getMasterFileSystem().prepareLogReplay(this.serverName, regions);
                    } else {
                        this.services.getMasterFileSystem().splitMetaLog(this.serverName);
                    }
                    am.getRegionStates().logSplit(HRegionInfo.FIRST_META_REGIONINFO);
                }
            }
            catch (IOException ioe) {
                this.services.getExecutorService().submit(this);
                this.deadServers.add(this.serverName);
                throw new IOException("failed log splitting for " + this.serverName + ", will retry", ioe);
            }
            if (am.isCarryingMeta(this.serverName)) {
                LOG.info("Server " + this.serverName + " was carrying META. Trying to assign.");
                am.regionOffline(HRegionInfo.FIRST_META_REGIONINFO);
                this.verifyAndAssignMetaWithRetries();
            } else if (!this.services.getCatalogTracker().isMetaLocationAvailable()) {
                this.verifyAndAssignMetaWithRetries();
            } else {
                LOG.info("META has been assigned to otherwhere, skip assigning.");
            }
            try {
                if (this.shouldSplitHlog && this.distributedLogReplay) {
                    if (!am.waitOnRegionToClearRegionsInTransition(HRegionInfo.FIRST_META_REGIONINFO, this.regionAssignmentWaitTimeout)) {
                        LOG.warn("Region " + HRegionInfo.FIRST_META_REGIONINFO.getEncodedName() + " didn't complete assignment in time");
                    }
                    this.services.getMasterFileSystem().splitMetaLog(this.serverName);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    this.services.getExecutorService().submit(this);
                    this.deadServers.add(this.serverName);
                    throw new IOException("failed log splitting for " + this.serverName + ", will retry", ex);
                }
                throw new IOException(ex);
            }
            gotException = false;
        }
        finally {
            if (gotException) {
                this.deadServers.finish(this.serverName);
            }
        }
        super.process();
        this.eventExceptionCount.set(0);
    }

    @Override
    boolean isCarryingMeta() {
        return true;
    }

    private void verifyAndAssignMeta() throws InterruptedException, IOException, KeeperException {
        long timeout = this.server.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        if (!this.server.getCatalogTracker().verifyMetaRegionLocation(timeout)) {
            this.services.getAssignmentManager().assignMeta();
        } else {
            if (this.serverName.equals(this.server.getCatalogTracker().getMetaLocation())) {
                throw new IOException("hbase:meta is onlined on the dead server " + this.serverName);
            }
            LOG.info("Skip assigning hbase:meta, because it is online on the " + this.server.getCatalogTracker().getMetaLocation());
        }
    }

    private void verifyAndAssignMetaWithRetries() throws IOException {
        int iTimes = this.server.getConfiguration().getInt("hbase.catalog.verification.retries", 10);
        long waitTime = this.server.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        int iFlag = 0;
        while (true) {
            try {
                this.verifyAndAssignMeta();
            }
            catch (KeeperException e) {
                this.server.abort("In server shutdown processing, assigning meta", e);
                throw new IOException("Aborting", e);
            }
            catch (Exception e) {
                if (iFlag >= iTimes) {
                    this.server.abort("verifyAndAssignMeta failed after" + iTimes + " times retries, aborting", e);
                    throw new IOException("Aborting", e);
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    LOG.warn("Interrupted when is the thread sleep", e1);
                    Thread.currentThread().interrupt();
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
                }
                ++iFlag;
                continue;
            }
            break;
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    @Override
    protected void handleException(Throwable t) {
        int count = this.eventExceptionCount.getAndIncrement();
        if (count < 0) {
            count = this.eventExceptionCount.getAndSet(0);
        }
        if (count > 100) {
            Threads.sleep(1000L);
        }
        if (count % 100 == 0) {
            LOG.error("Caught " + (Object)((Object)this.eventType) + ", count=" + this.eventExceptionCount, t);
        } else {
            LOG.error("Caught " + (Object)((Object)this.eventType) + ", count=" + this.eventExceptionCount + "; " + t.getMessage() + "; stack trace shows every " + 100 + "th time.");
        }
    }
}

