/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class OpenedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(OpenedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final ServerName sn;
    private final OpenedPriority priority;
    private final int expectedVersion;

    public OpenedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo, ServerName sn, int expectedVersion) {
        super(server, EventType.RS_ZK_REGION_OPENED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.sn = sn;
        this.expectedVersion = expectedVersion;
        this.priority = regionInfo.isMetaRegion() ? OpenedPriority.META : (regionInfo.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) ? OpenedPriority.SYSTEM : OpenedPriority.USER);
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    @Override
    public void process() {
        RegionState regionState = this.assignmentManager.getRegionStates().getRegionTransitionState(this.regionInfo.getEncodedName());
        boolean openedNodeDeleted = false;
        if (regionState != null && regionState.isOpened()) {
            openedNodeDeleted = this.deleteOpenedNode(this.expectedVersion);
            if (!openedNodeDeleted) {
                LOG.error("Znode of region " + this.regionInfo.getShortNameToLog() + " could not be deleted.");
            }
        } else {
            LOG.warn("Skipping the onlining of " + this.regionInfo.getShortNameToLog() + " because regions is NOT in RIT -- presuming this is because it SPLIT");
        }
        if (!openedNodeDeleted && this.assignmentManager.getZKTable().isDisablingOrDisabledTable(this.regionInfo.getTable())) {
            this.debugLog(this.regionInfo, "Opened region " + this.regionInfo.getShortNameToLog() + " but " + "this table is disabled, triggering close of region");
            this.assignmentManager.unassign(this.regionInfo);
        }
    }

    private boolean deleteOpenedNode(int expectedVersion) {
        this.debugLog(this.regionInfo, "Handling OPENED of " + this.regionInfo.getShortNameToLog() + " from " + this.sn.toString() + "; deleting unassigned node");
        try {
            return ZKAssign.deleteNode(this.server.getZooKeeper(), this.regionInfo.getEncodedName(), EventType.RS_ZK_REGION_OPENED, expectedVersion);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("The znode of the region " + this.regionInfo.getShortNameToLog() + " would have already been deleted");
            return false;
        }
        catch (KeeperException e) {
            this.server.abort("Error deleting OPENED node in ZK (" + this.regionInfo.getRegionNameAsString() + ")", e);
            return false;
        }
    }

    private void debugLog(HRegionInfo region, String string) {
        if (region.isMetaTable()) {
            LOG.info(string);
        } else {
            LOG.debug(string);
        }
    }

    private static enum OpenedPriority {
        META(1),
        SYSTEM(2),
        USER(3);

        private final int value;

        private OpenedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

