/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableDeleteFamilyHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLENAME = TableName.valueOf("column_family_handlers");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("cf1"), Bytes.toBytes("cf2"), Bytes.toBytes("cf3")};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createTable(TABLENAME, FAMILIES);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        while (TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition().size() > 0) {
            Thread.sleep(100L);
        }
        while (TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition().size() > 0) {
            Thread.sleep(100L);
        }
        TEST_UTIL.loadTable(t, FAMILIES);
        TEST_UTIL.flush();
        t.close();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.deleteTable(TABLENAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Test
    public void deleteColumnFamilyWithMultipleRegions() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor beforehtd = admin.getTableDescriptor(TABLENAME);
        FileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        Assert.assertTrue((boolean)admin.isTableAvailable(TABLENAME));
        Assert.assertEquals((long)3L, (long)beforehtd.getColumnFamilies().length);
        HColumnDescriptor[] families = beforehtd.getColumnFamilies();
        for (int i = 0; i < families.length; ++i) {
            Assert.assertTrue((boolean)families[i].getNameAsString().equals("cf" + (i + 1)));
        }
        Path tableDir = FSUtils.getTableDir(TEST_UTIL.getDefaultRootDirPath(), TABLENAME);
        Assert.assertTrue((boolean)fs.exists(tableDir));
        FileStatus[] fileStatus = fs.listStatus(tableDir);
        for (int i = 0; i < fileStatus.length; ++i) {
            if (!fileStatus[i].isDir()) continue;
            FileStatus[] cf = fs.listStatus(fileStatus[i].getPath());
            int k = 1;
            for (int j = 0; j < cf.length; ++j) {
                if (!cf[j].isDir() || cf[j].getPath().getName().startsWith(".")) continue;
                Assert.assertEquals((Object)cf[j].getPath().getName(), (Object)("cf" + k));
                ++k;
            }
        }
        admin.disableTable(TABLENAME);
        admin.deleteColumn(TABLENAME.getName(), "cf2");
        HTableDescriptor afterhtd = admin.getTableDescriptor(TABLENAME);
        Assert.assertEquals((long)2L, (long)afterhtd.getColumnFamilies().length);
        HColumnDescriptor[] newFamilies = afterhtd.getColumnFamilies();
        Assert.assertTrue((boolean)newFamilies[0].getNameAsString().equals("cf1"));
        Assert.assertTrue((boolean)newFamilies[1].getNameAsString().equals("cf3"));
        fileStatus = fs.listStatus(tableDir);
        for (int i = 0; i < fileStatus.length; ++i) {
            if (!fileStatus[i].isDir()) continue;
            FileStatus[] cf = fs.listStatus(fileStatus[i].getPath());
            for (int j = 0; j < cf.length; ++j) {
                if (!cf[j].isDir()) continue;
                Assert.assertFalse((boolean)cf[j].getPath().getName().equals("cf2"));
            }
        }
    }
}

