/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TableInfoCopyTask;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DisabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Log LOG = LogFactory.getLog(DisabledTableSnapshotHandler.class);
    private final TimeoutExceptionInjector timeoutInjector;

    public DisabledTableSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices masterServices) {
        super(snapshot, masterServices);
        this.timeoutInjector = TakeSnapshotUtils.getMasterTimerAndBindToMonitor(snapshot, this.conf, this.monitor);
    }

    @Override
    public DisabledTableSnapshotHandler prepare() throws Exception {
        return (DisabledTableSnapshotHandler)super.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotRegions(List<Pair<HRegionInfo, ServerName>> regionsAndLocations) throws IOException, KeeperException {
        try {
            this.timeoutInjector.start();
            Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.snapshot, this.rootDir);
            HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
            for (Pair<HRegionInfo, ServerName> p : regionsAndLocations) {
                regions.add(p.getFirst());
            }
            String msg = "Starting to write region info and WALs for regions for offline snapshot:" + ClientSnapshotDescriptionUtils.toString(this.snapshot);
            LOG.info(msg);
            this.status.setStatus(msg);
            for (HRegionInfo regionInfo : regions) {
                this.snapshotDisabledRegion(regionInfo);
            }
            LOG.info("Starting to copy tableinfo for offline snapshot: " + ClientSnapshotDescriptionUtils.toString(this.snapshot));
            TableInfoCopyTask tableInfoCopyTask = new TableInfoCopyTask(this.monitor, this.snapshot, this.fs, FSUtils.getRootDir(this.conf));
            tableInfoCopyTask.call();
            this.monitor.rethrowException();
            this.status.setStatus("Finished copying tableinfo for snapshot of table: " + this.snapshotTable);
        }
        catch (Exception e) {
            String reason = "Failed snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.status.abort("Snapshot of table: " + this.snapshotTable + " failed because " + e.getMessage());
        }
        finally {
            LOG.debug("Marking snapshot" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " as finished.");
            this.timeoutInjector.complete();
        }
    }
}

