/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SnapshotHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(SnapshotHFileCleaner.class);
    public static final String HFILE_CACHE_REFRESH_PERIOD_CONF_KEY = "hbase.master.hfilecleaner.plugins.snapshot.period";
    private static final long DEFAULT_HFILE_CACHE_REFRESH_PERIOD = 300000L;
    private SnapshotFileCache cache;

    @Override
    public synchronized boolean isFileDeletable(FileStatus fStat) {
        try {
            return !this.cache.contains(fStat.getPath().getName());
        }
        catch (IOException e) {
            LOG.error("Exception while checking if:" + fStat.getPath() + " was valid, keeping it just in case.", e);
            return false;
        }
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            long cacheRefreshPeriod = conf.getLong(HFILE_CACHE_REFRESH_PERIOD_CONF_KEY, 300000L);
            final FileSystem fs = FSUtils.getCurrentFileSystem(conf);
            Path rootDir = FSUtils.getRootDir(conf);
            this.cache = new SnapshotFileCache(fs, rootDir, cacheRefreshPeriod, cacheRefreshPeriod, "snapshot-hfile-cleaner-cache-refresher", new SnapshotFileCache.SnapshotFileInspector(){

                @Override
                public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
                    return SnapshotReferenceUtil.getHFileNames(fs, snapshotDir);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Failed to create cleaner util", e);
        }
    }

    @Override
    public void stop(String why) {
        this.cache.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.cache.isStopped();
    }

    public SnapshotFileCache getFileCacheForTesting() {
        return this.cache;
    }
}

