/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.migration.TestNamespaceUpgrade;
import org.apache.hadoop.hbase.migration.UpgradeTo96;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileV1Detector;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestUpgradeTo96 {
    static final Log LOG = LogFactory.getLog(TestUpgradeTo96.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path hbaseRootDir;
    private static ZooKeeperWatcher zkw;
    private static String replicationPeerZnode;
    private static String tableAZnode;
    private static ZooKeeperProtos.ReplicationPeer peer1;
    private static String peer1Znode;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        fs = FileSystem.get(TEST_UTIL.getConfiguration());
        FSUtils.setRootDir(TEST_UTIL.getConfiguration(), hbaseRootDir);
        zkw = TEST_UTIL.getZooKeeperWatcher();
        Path testdir = TEST_UTIL.getDataTestDir("TestUpgradeTo96");
        TestUpgradeTo96.set94FSLayout(testdir);
        TestUpgradeTo96.setUp94Znodes();
    }

    private static void set94FSLayout(Path testdir) throws IOException, Exception {
        File untar = TestNamespaceUpgrade.untar(new File(testdir.toString()));
        if (!fs.exists(hbaseRootDir.getParent())) {
            fs.mkdirs(hbaseRootDir.getParent());
        }
        FsShell shell = new FsShell(TEST_UTIL.getConfiguration());
        shell.run(new String[]{"-put", untar.toURI().toString(), hbaseRootDir.toString()});
        shell.run(new String[]{"-lsr", "/"});
    }

    private static void setUp94Znodes() throws IOException, KeeperException {
        String rootRegionServerZnode = ZKUtil.joinZNode(TestUpgradeTo96.zkw.baseZNode, "root-region-server");
        ZKUtil.createWithParents(zkw, rootRegionServerZnode);
        ZKUtil.createWithParents(zkw, TestUpgradeTo96.zkw.backupMasterAddressesZNode);
        tableAZnode = ZKUtil.joinZNode(TestUpgradeTo96.zkw.tableZNode, "a");
        ZKUtil.createWithParents(zkw, tableAZnode, Bytes.toBytes(ZooKeeperProtos.Table.State.ENABLED.toString()));
        String replicationZnode = ZKUtil.joinZNode(TestUpgradeTo96.zkw.baseZNode, "replication");
        replicationPeerZnode = ZKUtil.joinZNode(replicationZnode, "peers");
        peer1Znode = ZKUtil.joinZNode(replicationPeerZnode, "1");
        peer1 = ZooKeeperProtos.ReplicationPeer.newBuilder().setClusterkey("abc:123:/hbase").build();
        ZKUtil.createWithParents(zkw, peer1Znode, Bytes.toBytes(peer1.getClusterkey()));
    }

    @Test
    public void testHFileV1Detector() throws Exception {
        Assert.assertEquals((long)0L, (long)ToolRunner.run(TEST_UTIL.getConfiguration(), new HFileV1Detector(), null));
    }

    @Test
    public void testHFileV1DetectorWithCorruptFiles() throws Exception {
        FileStatus[] cfs;
        Path tablePath = new Path(hbaseRootDir, "foo");
        FileStatus[] regionsDir = fs.listStatus(tablePath);
        if (regionsDir == null) {
            throw new IOException("No Regions found for table foo");
        }
        Path columnFamilyDir = null;
        Path targetRegion = null;
        for (FileStatus s : regionsDir) {
            if (!fs.exists(new Path(s.getPath(), ".regioninfo"))) continue;
            targetRegion = s.getPath();
            break;
        }
        for (FileStatus f : cfs = fs.listStatus(targetRegion)) {
            if (!f.isDir()) continue;
            columnFamilyDir = f.getPath();
            break;
        }
        LOG.debug("target columnFamilyDir: " + columnFamilyDir);
        Path corruptFile = new Path(columnFamilyDir, "corrupt_file");
        if (!fs.createNewFile(corruptFile)) {
            throw new IOException("Couldn't create corrupt file: " + corruptFile);
        }
        Assert.assertEquals((long)1L, (long)ToolRunner.run(TEST_UTIL.getConfiguration(), new HFileV1Detector(), null));
        FileSystem.get(TEST_UTIL.getConfiguration()).delete(corruptFile, false);
    }

    @Test
    public void testHFileLink() throws Exception {
        Path rootDir = FSUtils.getRootDir(TEST_UTIL.getConfiguration());
        Path aFileLink = new Path(rootDir, "table/2086db948c48/cf/table=21212abcdc33-0906db948c48");
        Path preNamespaceTablePath = new Path(rootDir, "table/21212abcdc33/cf/0906db948c48");
        Path preNamespaceArchivePath = new Path(rootDir, ".archive/table/21212abcdc33/cf/0906db948c48");
        Path preNamespaceTempPath = new Path(rootDir, ".tmp/table/21212abcdc33/cf/0906db948c48");
        boolean preNSTablePathExists = false;
        boolean preNSArchivePathExists = false;
        boolean preNSTempPathExists = false;
        Assert.assertTrue((boolean)HFileLink.isHFileLink(aFileLink));
        HFileLink hFileLink = new HFileLink(TEST_UTIL.getConfiguration(), aFileLink);
        Assert.assertTrue((boolean)hFileLink.getArchivePath().toString().startsWith(rootDir.toString()));
        HFileV1Detector t = new HFileV1Detector();
        t.setConf(TEST_UTIL.getConfiguration());
        FileLink fileLink = t.getFileLinkWithPreNSPath(aFileLink);
        Assert.assertTrue((fileLink.getLocations().length == 6 ? 1 : 0) != 0);
        for (Path p : fileLink.getLocations()) {
            if (p.equals(preNamespaceArchivePath)) {
                preNSArchivePathExists = true;
            }
            if (p.equals(preNamespaceTablePath)) {
                preNSTablePathExists = true;
            }
            if (!p.equals(preNamespaceTempPath)) continue;
            preNSTempPathExists = true;
        }
        Assert.assertTrue((boolean)(preNSArchivePathExists & preNSTablePathExists & preNSTempPathExists));
    }

    @Test
    public void testADirForHFileV1() throws Exception {
        Path tablePath = new Path(hbaseRootDir, "foo");
        System.out.println("testADirForHFileV1: " + tablePath.makeQualified(fs));
        System.out.println("Passed: " + hbaseRootDir + "/foo");
        Assert.assertEquals((long)0L, (long)ToolRunner.run(TEST_UTIL.getConfiguration(), new HFileV1Detector(), new String[]{"-pfoo"}));
    }

    @Test
    public void testZnodeMigration() throws Exception {
        String rootRSZnode = ZKUtil.joinZNode(TestUpgradeTo96.zkw.baseZNode, "root-region-server");
        Assert.assertTrue((ZKUtil.checkExists(zkw, rootRSZnode) > -1 ? 1 : 0) != 0);
        ToolRunner.run(TEST_UTIL.getConfiguration(), new UpgradeTo96(), new String[]{"-execute"});
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists(zkw, rootRSZnode));
        byte[] data = ZKUtil.getData(zkw, tableAZnode);
        Assert.assertTrue((boolean)ProtobufUtil.isPBMagicPrefix(data));
        this.checkTableState(data, ZooKeeperProtos.Table.State.ENABLED);
        data = ZKUtil.getData(zkw, peer1Znode);
        Assert.assertTrue((boolean)ProtobufUtil.isPBMagicPrefix(data));
        this.checkReplicationPeerData(data, peer1);
    }

    private void checkTableState(byte[] data, ZooKeeperProtos.Table.State expectedState) throws InvalidProtocolBufferException {
        int magicLen;
        ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
        ZooKeeperProtos.Table t = ((ZooKeeperProtos.Table.Builder)builder.mergeFrom(data, magicLen = ProtobufUtil.lengthOfPBMagic(), data.length - magicLen)).build();
        Assert.assertTrue((t.getState() == expectedState ? 1 : 0) != 0);
    }

    private void checkReplicationPeerData(byte[] data, ZooKeeperProtos.ReplicationPeer peer) throws InvalidProtocolBufferException {
        int magicLen = ProtobufUtil.lengthOfPBMagic();
        ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
        Assert.assertEquals((Object)((ZooKeeperProtos.ReplicationPeer.Builder)builder.mergeFrom(data, magicLen, data.length - magicLen)).build().getClusterkey(), (Object)peer.getClusterkey());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL.shutdownMiniDFSCluster();
        TEST_UTIL.shutdownMiniZKCluster();
    }
}

