/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.primitives.Bytes;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;

@InterfaceAudience.Private
public class DelimitedKeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Log LOG = LogFactory.getLog(DelimitedKeyPrefixRegionSplitPolicy.class);
    public static final String DELIMITER_KEY = "DelimitedKeyPrefixRegionSplitPolicy.delimiter";
    private byte[] delimiter = null;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        if (region != null) {
            String delimiterString = region.getTableDesc().getValue(DELIMITER_KEY);
            if (delimiterString == null || delimiterString.length() == 0) {
                LOG.error("DelimitedKeyPrefixRegionSplitPolicy.delimiter not specified for table " + region.getTableDesc().getTableName() + ". Using default RegionSplitPolicy");
                return;
            }
            this.delimiter = org.apache.hadoop.hbase.util.Bytes.toBytes(delimiterString);
        }
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (splitPoint != null && this.delimiter != null) {
            int index = Bytes.indexOf(splitPoint, this.delimiter);
            if (index < 0) {
                LOG.warn("Delimiter " + org.apache.hadoop.hbase.util.Bytes.toString(this.delimiter) + "  not found for split key " + org.apache.hadoop.hbase.util.Bytes.toString(splitPoint));
                return splitPoint;
            }
            return Arrays.copyOf(splitPoint, Math.min(index, splitPoint.length));
        }
        return splitPoint;
    }
}

